/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering;

import java.io.Serializable;
import java.util.Properties;

public class Member
implements Serializable {
    private String hostName;
    private int port = -1;
    private int httpPort = -1;
    private int httpsPort = -1;
    private boolean isActive = true;
    private String domain;
    private Properties properties = new Properties();
    private long suspendedTime = -1L;
    private long suspensionDuration = -1L;
    private String remoteHost;

    public Member(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    public void suspend(long suspensionDurationMillis) {
        this.suspendedTime = System.currentTimeMillis();
        this.suspensionDuration = suspensionDurationMillis;
    }

    public boolean isSuspended() {
        if (this.suspendedTime == -1L) {
            return false;
        }
        if (System.currentTimeMillis() - this.suspendedTime >= this.suspensionDuration) {
            this.suspendedTime = -1L;
            this.suspensionDuration = -1L;
            return false;
        }
        return true;
    }

    public String getHostName() {
        String remoteHost = this.properties.getProperty("remoteHost");
        if (remoteHost != null) {
            return remoteHost;
        }
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public boolean equals(Object o) {
        boolean isIdenticalPorts;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        boolean bl = isIdenticalPorts = this.port == member.getPort() && this.httpPort == member.getHttpPort() && this.httpsPort == member.getHttpsPort();
        return isIdenticalPorts && (this.remoteHost != null ? this.remoteHost.equals(member.getRemoteHost()) : member.getRemoteHost() == null) && (this.hostName != null ? this.hostName.equals(member.getHostName()) : member.getHostName() == null);
    }

    public int hashCode() {
        int result = this.hostName != null ? this.hostName.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "Host:" + this.hostName + ", Remote Host:" + this.remoteHost + ", Port: " + this.port + ", HTTP:" + this.httpPort + ", HTTPS:" + this.httpsPort + ", Domain: " + this.domain + ", Sub-domain:" + this.properties.getProperty("subDomain") + ", Active:" + this.isActive;
    }
}

