/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.util;

import java.io.File;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.CarbonUtils;

public class ConfUtil {
    private static final String CONFIG_FILE_NAME = "stratos-config";
    private static Log log = LogFactory.getLog(ConfUtil.class);
    private XMLConfiguration config;
    private static ConfUtil instance = null;

    private ConfUtil(String configFilePath) {
        log.info((Object)"Loading configuration.....");
        try {
            File confFile = configFilePath != null && !configFilePath.isEmpty() ? new File(configFilePath) : new File(CarbonUtils.getCarbonConfigDirPath(), CONFIG_FILE_NAME);
            this.config = new XMLConfiguration(confFile);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Unable to load autoscaler configuration file", (Throwable)e);
            this.config = new XMLConfiguration();
        }
    }

    public static ConfUtil getInstance(String configFilePath) {
        if (instance == null) {
            instance = new ConfUtil(configFilePath);
        }
        return instance;
    }

    public XMLConfiguration getConfiguration() {
        return this.config;
    }
}

