/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.client;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceApplicatioinPolicyNotExistsExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceApplicationDefinitionExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceApplicationPolicyAlreadyExistsExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceAutoScalerExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceAutoScalingPolicyAlreadyExistExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceCartridgeGroupNotFoundExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceCartridgeNotFoundExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceCloudControllerConnectionExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceDeploymentPolicyAlreadyExistsExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceDeploymentPolicyNotExistsExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceInvalidApplicationPolicyExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceInvalidArgumentExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceInvalidDeploymentPolicyExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceInvalidPolicyExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceInvalidServiceGroupExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServicePolicyDoesNotExistExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceRemoteExceptionException;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceStub;
import org.apache.stratos.autoscaler.stub.AutoscalerServiceUnremovablePolicyExceptionException;
import org.apache.stratos.autoscaler.stub.Properties;
import org.apache.stratos.autoscaler.stub.autoscale.policy.AutoscalePolicy;
import org.apache.stratos.autoscaler.stub.deployment.policy.ApplicationPolicy;
import org.apache.stratos.autoscaler.stub.deployment.policy.DeploymentPolicy;
import org.apache.stratos.autoscaler.stub.pojo.ApplicationContext;
import org.apache.stratos.autoscaler.stub.pojo.ServiceGroup;

public class AutoscalerServiceClient {
    private AutoscalerServiceStub stub;
    private static final Log log = LogFactory.getLog(AutoscalerServiceClient.class);
    private static volatile AutoscalerServiceClient instance;

    private AutoscalerServiceClient(String epr) throws AxisFault {
        String autosclaerSocketTimeout = System.getProperty("autoscaler.socket.timeout") == null ? "300000" : System.getProperty("autoscaler.socket.timeout");
        String autosclaerConnectionTimeout = System.getProperty("autoscaler.connection.timeout") == null ? "300000" : System.getProperty("autoscaler.connection.timeout");
        try {
            this.stub = new AutoscalerServiceStub(epr);
            this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)Integer.valueOf(autosclaerSocketTimeout));
            this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)Integer.valueOf(autosclaerConnectionTimeout));
        }
        catch (AxisFault axisFault) {
            String msg = "Could not initialize autoscaler service client";
            log.error((Object)msg, (Throwable)axisFault);
            throw new AxisFault(msg, (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoscalerServiceClient getInstance() throws AxisFault {
        if (instance != null) return instance;
        Class<AutoscalerServiceClient> clazz = AutoscalerServiceClient.class;
        synchronized (AutoscalerServiceClient.class) {
            if (instance != null) return instance;
            instance = new AutoscalerServiceClient(System.getProperty("autoscaler.service.url"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void undeployServiceGroupDefinition(String serviceGroupName) throws RemoteException, AutoscalerServiceCartridgeGroupNotFoundExceptionException {
        this.stub.removeServiceGroup(serviceGroupName);
    }

    public AutoscalePolicy[] getAutoScalePolicies() throws RemoteException {
        return this.stub.getAutoScalingPolicies();
    }

    public AutoscalePolicy getAutoScalePolicy(String autoscalingPolicyId) throws RemoteException {
        return this.stub.getAutoscalingPolicy(autoscalingPolicyId);
    }

    public void addApplication(ApplicationContext applicationContext) throws AutoscalerServiceApplicationDefinitionExceptionException, RemoteException, AutoscalerServiceCartridgeNotFoundExceptionException, AutoscalerServiceCartridgeGroupNotFoundExceptionException {
        this.stub.addApplication(applicationContext);
    }

    public void updateApplication(ApplicationContext applicationContext) throws AutoscalerServiceApplicationDefinitionExceptionException, RemoteException, AutoscalerServiceCartridgeNotFoundExceptionException, AutoscalerServiceCartridgeGroupNotFoundExceptionException {
        this.stub.updateApplication(applicationContext);
    }

    public ApplicationContext getApplication(String applicationId) throws RemoteException {
        return this.stub.getApplication(applicationId);
    }

    public boolean existApplication(String applicationId) throws RemoteException {
        return this.stub.existApplication(applicationId);
    }

    public ApplicationContext[] getApplications() throws RemoteException {
        return this.stub.getApplications();
    }

    public boolean deployApplication(String applicationId, String applicationPolicyId) throws RemoteException, AutoscalerServiceInvalidPolicyExceptionException, AutoscalerServiceApplicationDefinitionExceptionException {
        return this.stub.deployApplication(applicationId, applicationPolicyId);
    }

    public void addApplicationPolicy(ApplicationPolicy applicationPolicy) throws RemoteException, AutoscalerServiceRemoteExceptionException, AutoscalerServiceInvalidApplicationPolicyExceptionException, AutoscalerServiceApplicationPolicyAlreadyExistsExceptionException {
        this.stub.addApplicationPolicy(applicationPolicy);
    }

    public ApplicationPolicy getApplicationPolicy(String applicationPolicyId) throws RemoteException {
        return this.stub.getApplicationPolicy(applicationPolicyId);
    }

    public ApplicationPolicy[] getApplicationPolicies() throws RemoteException {
        return this.stub.getApplicationPolicies();
    }

    public void updateApplicationPolicy(ApplicationPolicy applicationPolicy) throws RemoteException, AutoscalerServiceApplicatioinPolicyNotExistsExceptionException, AutoscalerServiceRemoteExceptionException, AutoscalerServiceInvalidApplicationPolicyExceptionException {
        this.stub.updateApplicationPolicy(applicationPolicy);
    }

    public void removeApplicationPolicy(String applicationPolicyId) throws RemoteException, AutoscalerServiceInvalidPolicyExceptionException, AutoscalerServiceUnremovablePolicyExceptionException {
        this.stub.removeApplicationPolicy(applicationPolicyId);
    }

    public String[] getApplicationNetworkPartitions(String applicationId) throws RemoteException, AutoscalerServiceAutoScalerExceptionException {
        return this.stub.getApplicationNetworkPartitions(applicationId);
    }

    public void undeployApplication(String applicationId, boolean force) throws AutoscalerServiceApplicationDefinitionExceptionException, RemoteException {
        this.stub.undeployApplication(applicationId, force);
    }

    public void deleteApplication(String applicationId) throws RemoteException {
        this.stub.deleteApplication(applicationId);
    }

    public boolean addAutoscalingPolicy(AutoscalePolicy autoScalePolicy) throws RemoteException, AutoscalerServiceAutoScalingPolicyAlreadyExistExceptionException {
        return this.stub.addAutoScalingPolicy(autoScalePolicy);
    }

    public boolean updateAutoscalingPolicy(AutoscalePolicy autoScalePolicy) throws RemoteException, AutoscalerServiceInvalidPolicyExceptionException {
        return this.stub.updateAutoScalingPolicy(autoScalePolicy);
    }

    public boolean removeAutoscalingPolicy(String autoScalePolicyId) throws RemoteException, AutoscalerServicePolicyDoesNotExistExceptionException, AutoscalerServiceUnremovablePolicyExceptionException {
        return this.stub.removeAutoScalingPolicy(autoScalePolicyId);
    }

    public ServiceGroup getServiceGroup(String serviceGroupDefinitionName) throws RemoteException {
        return this.stub.getServiceGroup(serviceGroupDefinitionName);
    }

    public ServiceGroup[] getServiceGroups() throws RemoteException, AutoscalerServiceAutoScalerExceptionException {
        return this.stub.getServiceGroups();
    }

    public void addServiceGroup(ServiceGroup serviceGroup) throws AutoscalerServiceInvalidServiceGroupExceptionException, RemoteException {
        this.stub.addServiceGroup(serviceGroup);
    }

    public void updateServiceGroup(ServiceGroup serviceGroup) throws AutoscalerServiceInvalidServiceGroupExceptionException, RemoteException {
        this.stub.updateServiceGroup(serviceGroup);
    }

    public void removeServiceGroup(String groupName) throws RemoteException, AutoscalerServiceCartridgeGroupNotFoundExceptionException {
        this.stub.removeServiceGroup(groupName);
    }

    public void updateClusterMonitor(String clusterId, Properties properties) throws RemoteException, AutoscalerServiceInvalidArgumentExceptionException {
        this.stub.updateClusterMonitor(clusterId, properties);
    }

    public String findClusterId(String applicationId, String alias) throws RemoteException {
        return this.stub.findClusterId(applicationId, alias);
    }

    public void addDeploymentPolicy(DeploymentPolicy deploymentPolicy) throws RemoteException, AutoscalerServiceRemoteExceptionException, AutoscalerServiceInvalidDeploymentPolicyExceptionException, AutoscalerServiceDeploymentPolicyAlreadyExistsExceptionException {
        this.stub.addDeployementPolicy(deploymentPolicy);
    }

    public void updateDeploymentPolicy(DeploymentPolicy deploymentPolicy) throws RemoteException, AutoscalerServiceDeploymentPolicyNotExistsExceptionException, AutoscalerServiceInvalidDeploymentPolicyExceptionException, AutoscalerServiceRemoteExceptionException, AutoscalerServiceInvalidPolicyExceptionException, AutoscalerServiceCloudControllerConnectionExceptionException {
        this.stub.updateDeploymentPolicy(deploymentPolicy);
    }

    public void removeDeploymentPolicy(String deploymentPolicyID) throws RemoteException, AutoscalerServiceDeploymentPolicyNotExistsExceptionException, AutoscalerServiceUnremovablePolicyExceptionException {
        this.stub.removeDeployementPolicy(deploymentPolicyID);
    }

    public DeploymentPolicy getDeploymentPolicy(String deploymentPolicyID) throws RemoteException {
        return this.stub.getDeploymentPolicy(deploymentPolicyID);
    }

    public DeploymentPolicy[] getDeploymentPolicies() throws RemoteException {
        return this.stub.getDeploymentPolicies();
    }
}

