/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.statistics.notifier;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.statistics.publisher.InFlightRequestPublisher;
import org.apache.stratos.common.statistics.publisher.InFlightRequestPublisherFactory;
import org.apache.stratos.common.statistics.publisher.StatisticsPublisherType;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.domain.Service;
import org.apache.stratos.load.balancer.common.statistics.LoadBalancerStatisticsReader;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;

public class LoadBalancerStatisticsNotifier
implements Runnable {
    private static final Log log = LogFactory.getLog(LoadBalancerStatisticsNotifier.class);
    private final LoadBalancerStatisticsReader statsReader;
    private final TopologyProvider topologyProvider;
    private final InFlightRequestPublisher inFlightRequestPublisher;
    private long statsPublisherInterval = 15000L;
    private String networkPartitionId;
    private boolean terminated;

    public LoadBalancerStatisticsNotifier(LoadBalancerStatisticsReader statsReader, TopologyProvider topologyProvider) {
        this.statsReader = statsReader;
        this.topologyProvider = topologyProvider;
        this.inFlightRequestPublisher = InFlightRequestPublisherFactory.createInFlightRequestPublisher((StatisticsPublisherType)StatisticsPublisherType.WSO2CEP);
        String interval = System.getProperty("stats.notifier.interval");
        if (interval != null) {
            this.statsPublisherInterval = Long.getLong(interval);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("stats.notifier.interval: %dms", this.statsPublisherInterval));
        }
        this.networkPartitionId = System.getProperty("network.partition.id");
        if (StringUtils.isBlank((CharSequence)this.networkPartitionId)) {
            throw new RuntimeException("network.partition.id system property was not found.");
        }
    }

    @Override
    public void run() {
        while (!this.terminated) {
            try {
                try {
                    Thread.sleep(this.statsPublisherInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Publishing load balancer statistics");
                }
                if (this.inFlightRequestPublisher.isEnabled()) {
                    String clusterInstanceId = this.statsReader.getClusterInstanceId();
                    for (Service service : this.topologyProvider.getTopology().getServices()) {
                        for (Cluster cluster : service.getClusters()) {
                            int requestCount = this.statsReader.getInFlightRequestCount(cluster.getClusterId());
                            this.inFlightRequestPublisher.publish(cluster.getClusterId(), clusterInstanceId, this.networkPartitionId, requestCount);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("In-flight request count published to cep: [cluster-id] %s [cluster-instance-id] %s [network-partition] %s [value] %d ", cluster.getClusterId(), clusterInstanceId, this.networkPartitionId, requestCount));
                        }
                    }
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"In-flight request count publisher is disabled");
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Could not publish load balancer statistics", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

