/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.cache.CacheManager;
import javax.cache.CacheManagerFactory;
import javax.cache.CachingShutdownException;
import javax.cache.OptionalFeature;
import javax.cache.spi.AnnotationProvider;
import javax.cache.spi.CachingProvider;
import org.wso2.carbon.caching.impl.DataHolder;

public final class Caching {
    public static final String DEFAULT_CACHE_MANAGER_NAME = "__default__";

    private Caching() {
    }

    public static CacheManagerFactory getCacheManagerFactory() {
        return ServiceFactoryHolder.INSTANCE.getCachingProvider().getCacheManagerFactory();
    }

    public static CacheManager getCacheManager() {
        return Caching.getCacheManager(DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader) {
        return Caching.getCacheManager(classLoader, DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(String name) {
        return Caching.getCacheManagerFactory().getCacheManager(name);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader, String name) {
        return Caching.getCacheManagerFactory().getCacheManager(classLoader, name);
    }

    public static void close() throws CachingShutdownException {
        Caching.getCacheManagerFactory().close();
    }

    public static boolean close(ClassLoader classLoader) throws CachingShutdownException {
        return Caching.getCacheManagerFactory().close(classLoader);
    }

    public static boolean close(ClassLoader classLoader, String name) throws CachingShutdownException {
        return Caching.getCacheManagerFactory().close(classLoader, name);
    }

    public static boolean isSupported(OptionalFeature optionalFeature) {
        return ServiceFactoryHolder.INSTANCE.getCachingProvider().isSupported(optionalFeature);
    }

    public static boolean isAnnotationsSupported() {
        AnnotationProvider annotationProvider = ServiceFactoryHolder.INSTANCE.getAnnotationProvider();
        return annotationProvider != null && annotationProvider.isSupported();
    }

    private static enum ServiceFactoryHolder {
        INSTANCE;

        private List<CachingProvider> cachingProviders;
        private List<AnnotationProvider> annotationProviders;

        private ServiceFactoryHolder() {
            this.init();
        }

        private void init() {
            this.cachingProviders = AccessController.doPrivileged(new PrivilegedAction<List<CachingProvider>>(){

                @Override
                public List<CachingProvider> run() {
                    ArrayList<CachingProvider> result = new ArrayList<CachingProvider>();
                    result.add(DataHolder.getInstance().getCachingProvider());
                    return result;
                }
            });
            this.annotationProviders = AccessController.doPrivileged(new PrivilegedAction<List<AnnotationProvider>>(){

                @Override
                public List<AnnotationProvider> run() {
                    ArrayList<AnnotationProvider> result = new ArrayList<AnnotationProvider>();
                    result.add(DataHolder.getInstance().getAnnotationProvider());
                    return result;
                }
            });
        }

        public CachingProvider getCachingProvider() {
            switch (this.cachingProviders.size()) {
                case 0: {
                    this.init();
                    if (this.cachingProviders.size() == 0) {
                        throw new IllegalStateException("No CachingProviders found in classpath.");
                    }
                    return this.cachingProviders.get(0);
                }
                case 1: {
                    return this.cachingProviders.get(0);
                }
            }
            throw new IllegalStateException("Multiple CachingProviders found in classpath. There should only be one. CachingProviders found were: " + ServiceFactoryHolder.createListOfClassNames(this.cachingProviders));
        }

        public AnnotationProvider getAnnotationProvider() {
            switch (this.annotationProviders.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.annotationProviders.get(0);
                }
            }
            throw new IllegalStateException("Multiple AnnotationProviders found in classpath. There should only be one. CachingProviders found were: " + ServiceFactoryHolder.createListOfClassNames(this.annotationProviders));
        }

        private static String createListOfClassNames(Collection<?> names) {
            if (names.isEmpty()) {
                return "<none>";
            }
            StringBuilder sb = new StringBuilder();
            Iterator<?> it = names.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                sb.append(o.getClass().getName());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }
}

