/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.instance.notifier;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageListener;
import org.apache.stratos.messaging.message.receiver.instance.notifier.InstanceNotifierEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class InstanceNotifierEventReceiver {
    private static final Log log = LogFactory.getLog(InstanceNotifierEventReceiver.class);
    private final InstanceNotifierEventMessageDelegator messageDelegator;
    private final InstanceNotifierEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private boolean terminated;

    public InstanceNotifierEventReceiver() {
        InstanceNotifierEventMessageQueue messageQueue = new InstanceNotifierEventMessageQueue();
        this.messageDelegator = new InstanceNotifierEventMessageDelegator(messageQueue);
        this.messageListener = new InstanceNotifierEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block7: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.INSTANCE_NOTIFIER_TOPIC.getTopicName(), this.messageListener);
                Thread subscriberThread = new Thread(this.eventSubscriber);
                subscriberThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message receiver thread started");
                }
                Thread receiverThread = new Thread(this.messageDelegator);
                receiverThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message delegator thread started");
                }
                while (!this.terminated) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
            }
        }
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }
}

