/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.CompleteTopologyEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyMemberFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class CompleteTopologyMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(CompleteTopologyMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (CompleteTopologyEvent.class.getName().equals(type)) {
            CompleteTopologyEvent event = (CompleteTopologyEvent)MessagingUtil.jsonToObject(message, CompleteTopologyEvent.class);
            if (!topology.isInitialized()) {
                TopologyUpdater.acquireWriteLock();
                try {
                    this.doProcess(event, topology);
                }
                finally {
                    TopologyUpdater.releaseWriteLock();
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        return false;
    }

    private void doProcess(CompleteTopologyEvent event, Topology topology) {
        for (Service service : event.getTopology().getServices()) {
            if (TopologyServiceFilter.apply(service.getServiceName())) continue;
            topology.addService(service);
        }
        for (Service service : topology.getServices()) {
            ArrayList<Cluster> clustersToRemove = new ArrayList<Cluster>();
            for (Cluster cluster : service.getClusters()) {
                if (TopologyApplicationFilter.apply(cluster.getAppId())) {
                    clustersToRemove.add(cluster);
                    continue;
                }
                if (TopologyClusterFilter.apply(cluster.getClusterId())) {
                    clustersToRemove.add(cluster);
                    continue;
                }
                if (topology.clusterExist(cluster.getClusterId())) continue;
                topology.addToCluterMap(cluster);
            }
            for (Cluster cluster : clustersToRemove) {
                service.removeCluster(cluster);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Cluster is excluded: [cluster] %s", cluster.getClusterId()));
            }
        }
        for (Service service : topology.getServices()) {
            for (Cluster cluster : service.getClusters()) {
                ArrayList<Member> membersToRemove = new ArrayList<Member>();
                for (Member member : cluster.getMembers()) {
                    if (!TopologyMemberFilter.apply(member.getLbClusterId(), member.getNetworkPartitionId())) continue;
                    membersToRemove.add(member);
                }
                for (Member member : membersToRemove) {
                    cluster.removeMember(member);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Member is excluded: [member] %s [lb-cluster-id] %s", member.getMemberId(), member.getLbClusterId()));
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Topology initialized");
        }
        topology.setInitialized(true);
    }
}

