/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.tenant.CompleteTenantEventListener;
import org.apache.stratos.messaging.listener.tenant.TenantCreatedEventListener;
import org.apache.stratos.messaging.listener.tenant.TenantRemovedEventListener;
import org.apache.stratos.messaging.listener.tenant.TenantUpdatedEventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.tenant.CompleteTenantMessageProcessor;
import org.apache.stratos.messaging.message.processor.tenant.TenantCreatedMessageProcessor;
import org.apache.stratos.messaging.message.processor.tenant.TenantRemovedMessageProcessor;
import org.apache.stratos.messaging.message.processor.tenant.TenantUpdatedMessageProcessor;

public class TenantMessageProcessorChain
extends MessageProcessorChain {
    private static final Log log = LogFactory.getLog(TenantMessageProcessorChain.class);
    private CompleteTenantMessageProcessor completeTenantMessageProcessor;
    private TenantCreatedMessageProcessor tenantCreatedMessageProcessor;
    private TenantUpdatedMessageProcessor tenantUpdatedMessageProcessor;
    private TenantRemovedMessageProcessor tenantRemovedMessageProcessor;

    @Override
    public void initialize() {
        this.completeTenantMessageProcessor = new CompleteTenantMessageProcessor();
        this.add(this.completeTenantMessageProcessor);
        this.tenantCreatedMessageProcessor = new TenantCreatedMessageProcessor();
        this.add(this.tenantCreatedMessageProcessor);
        this.tenantUpdatedMessageProcessor = new TenantUpdatedMessageProcessor();
        this.add(this.tenantUpdatedMessageProcessor);
        this.tenantRemovedMessageProcessor = new TenantRemovedMessageProcessor();
        this.add(this.tenantRemovedMessageProcessor);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant message processor chain initialized");
        }
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        if (eventListener instanceof CompleteTenantEventListener) {
            this.completeTenantMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof TenantCreatedEventListener) {
            this.tenantCreatedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof TenantUpdatedEventListener) {
            this.tenantUpdatedMessageProcessor.addEventListener(eventListener);
        } else if (eventListener instanceof TenantRemovedEventListener) {
            this.tenantRemovedMessageProcessor.addEventListener(eventListener);
        } else {
            throw new RuntimeException("Unknown event listener");
        }
    }
}

