/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.event.tenant.TenantCreatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class TenantCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(TenantCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (TenantCreatedEvent.class.getName().equals(type)) {
            if (!TenantManager.getInstance().isInitialized()) {
                return false;
            }
            TenantCreatedEvent event = (TenantCreatedEvent)MessagingUtil.jsonToObject(message, TenantCreatedEvent.class);
            try {
                TenantManager.acquireWriteLock();
                TenantManager.getInstance().addTenant(event.getTenant());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Tenant created: [tenant-id] %d [tenant-domain] %s", event.getTenant().getTenantId(), event.getTenant().getTenantDomain()));
                }
                this.notifyEventListeners(event);
                boolean bl = true;
                return bl;
            }
            finally {
                TenantManager.releaseWriteLock();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process tenant message using available message processors: [type] %s [body] %s", type, message));
    }
}

