/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.domain.mapping;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Application;
import org.apache.stratos.messaging.domain.application.signup.DomainMapping;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.event.domain.mapping.DomainMappingAddedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.application.ApplicationManager;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingManager;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.util.MessagingUtil;

public class DomainMappingAddedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(DomainMappingAddedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (DomainMappingAddedEvent.class.getName().equals(type)) {
            if (!DomainMappingManager.getInstance().isInitialized()) {
                return false;
            }
            DomainMappingAddedEvent event = (DomainMappingAddedEvent)MessagingUtil.jsonToObject(message, DomainMappingAddedEvent.class);
            int tenantId = event.getTenantId();
            String applicationId = event.getApplicationId();
            try {
                boolean bl;
                TenantManager.acquireReadLock();
                Tenant tenant = TenantManager.getInstance().getTenant(tenantId);
                if (tenant == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Tenant not found: [tenant-id] %d", tenantId));
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                ApplicationManager.acquireReadLockForApplication(applicationId);
                Application application = ApplicationManager.getApplications().getApplication(applicationId);
                if (application == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)String.format("Application not found: [application-id] %d", applicationId));
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                try {
                    DomainMappingManager.acquireWriteLock();
                    DomainMapping domainMapping = new DomainMapping();
                    domainMapping.setTenantId(event.getTenantId());
                    domainMapping.setApplicationId(event.getApplicationId());
                    domainMapping.setServiceName(event.getServiceName());
                    domainMapping.setClusterId(event.getClusterId());
                    domainMapping.setDomainName(event.getDomainName());
                    domainMapping.setContextPath(event.getContextPath());
                    DomainMappingManager.getInstance().addDomainMapping(domainMapping);
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Domain mapping added: [application-id] %s [cluster-id] %s [domain-name]", event.getApplicationId(), event.getClusterId(), event.getDomainName()));
                    }
                    this.notifyEventListeners(event);
                    bl = true;
                }
                catch (Exception e) {
                    String error = String.format("Could not add domain mapping: [application-id] %s [cluster-id] %s [domain-name]", event.getApplicationId(), event.getClusterId(), event.getDomainName());
                    log.error((Object)error, (Throwable)e);
                    boolean bl4 = false;
                    DomainMappingManager.releaseWriteLock();
                    ApplicationManager.releaseReadLockForApplication(applicationId);
                    TenantManager.releaseReadLock();
                    return bl4;
                    {
                        catch (Throwable throwable) {
                            DomainMappingManager.releaseWriteLock();
                            throw throwable;
                        }
                    }
                }
                DomainMappingManager.releaseWriteLock();
                return bl;
            }
            finally {
                ApplicationManager.releaseReadLockForApplication(applicationId);
                TenantManager.releaseReadLock();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process domain mapping using available message processors: [type] %s [body] %s", type, message));
    }
}

