/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect.mqtt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicPublisher;
import org.apache.stratos.messaging.broker.connect.mqtt.MqttTopicConnector;
import org.apache.stratos.messaging.domain.exception.MessagingException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttTopicPublisher
extends MqttTopicConnector
implements TopicPublisher {
    protected static final Log log = LogFactory.getLog(MqttTopicPublisher.class);
    private String topicName;

    public MqttTopicPublisher(String topicName) {
        this.topicName = topicName;
        this.create();
    }

    @Override
    public void publish(String message, boolean retry) {
        try {
            if (this.mqttClient == null) {
                String error = "Could not publish message to topic, MQTT client has not been initialized";
                if (log.isErrorEnabled()) {
                    log.error((Object)error);
                }
                throw new MessagingException(error);
            }
            MqttMessage mqttMessage = new MqttMessage(message.getBytes());
            mqttMessage.setQos(2);
            this.mqttClient.publish(this.topicName, mqttMessage);
        }
        catch (Exception e) {
            String errorMessage = "Could not publish message: " + message;
            log.error((Object)errorMessage, (Throwable)e);
            throw new MessagingException(errorMessage, e);
        }
    }
}

