/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate.indexer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassSession;
import org.compass.gps.device.hibernate.HibernateGpsDevice;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.entities.EntityInformation;
import org.compass.gps.device.hibernate.indexer.HibernateIndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Order;
import org.hibernate.metadata.ClassMetadata;

public class ScrollableHibernateIndexEntitiesIndexer
implements HibernateIndexEntitiesIndexer {
    private static final Log log = LogFactory.getLog(ScrollableHibernateIndexEntitiesIndexer.class);
    private HibernateGpsDevice device;
    private boolean performOrderById = true;
    private Map<String, Boolean> performOrderByPerEntity = new HashMap<String, Boolean>();

    public void setHibernateGpsDevice(HibernateGpsDevice device) {
        this.device = device;
    }

    public void setPerformOrderById(boolean performOrderById) {
        this.performOrderById = performOrderById;
    }

    public void setPerformOrderById(String entity, boolean performOrderById) {
        this.performOrderByPerEntity.put(entity, performOrderById);
    }

    public void performIndex(CompassSession session, IndexEntity[] entities) {
        for (IndexEntity entity : entities) {
            EntityInformation entityInformation = (EntityInformation)entity;
            if (this.device.isFilteredForIndex(entityInformation.getName())) continue;
            if (!this.device.isRunning()) {
                return;
            }
            ScrollableResults cursor = null;
            Session hibernateSession = this.device.getSessionFactory().openSession();
            hibernateSession.setCacheMode(CacheMode.IGNORE);
            Transaction hibernateTransaction = null;
            try {
                Criteria criteria;
                hibernateTransaction = hibernateSession.beginTransaction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.device.buildMessage("Indexing entities [" + entityInformation.getName() + "] using query [" + entityInformation.getQueryProvider() + "]"));
                }
                if ((criteria = entityInformation.getQueryProvider().createCriteria((org.hibernate.Session)hibernateSession, entityInformation)) != null) {
                    ClassMetadata metadata;
                    String idPropName;
                    Boolean performOrder;
                    if (this.performOrderById && ((performOrder = this.performOrderByPerEntity.get(entityInformation.getName())) == null || performOrder.booleanValue()) && (idPropName = (metadata = hibernateSession.getSessionFactory().getClassMetadata(entityInformation.getName())).getIdentifierPropertyName()) != null) {
                        criteria.addOrder(Order.asc((String)idPropName));
                    }
                    criteria.setFetchSize(this.device.getFetchCount());
                    cursor = criteria.scroll(ScrollMode.FORWARD_ONLY);
                } else {
                    Query query = entityInformation.getQueryProvider().createQuery((org.hibernate.Session)hibernateSession, entityInformation);
                    cursor = query.scroll(ScrollMode.FORWARD_ONLY);
                }
                RowBuffer buffer = new RowBuffer(session, (org.hibernate.Session)hibernateSession, this.device.getFetchCount());
                Object prev = null;
                while (true) {
                    try {
                        if (!cursor.next()) {
                            break;
                        }
                    }
                    catch (ObjectNotFoundException e) {
                        continue;
                    }
                    Object item = cursor.get(0);
                    if (prev != null && item != prev) {
                        buffer.put(prev);
                    }
                    prev = item;
                    if (!buffer.shouldFlush()) continue;
                    buffer.put(prev);
                    buffer.flush();
                    prev = null;
                }
                if (prev != null) {
                    buffer.put(prev);
                }
                buffer.close();
                cursor.close();
                hibernateTransaction.commit();
            }
            catch (Exception e) {
                log.error((Object)this.device.buildMessage("Failed to index the database"), (Throwable)e);
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Exception e1) {
                        log.warn((Object)this.device.buildMessage("Failed to close cursor on error, ignoring"), (Throwable)e1);
                    }
                }
                if (hibernateTransaction != null) {
                    try {
                        hibernateTransaction.rollback();
                    }
                    catch (Exception e1) {
                        log.warn((Object)"Failed to rollback Hibernate", (Throwable)e1);
                    }
                }
                if (!(e instanceof HibernateGpsDeviceException)) {
                    throw new HibernateGpsDeviceException(this.device.buildMessage("Failed to index the database"), e);
                }
                throw (HibernateGpsDeviceException)e;
            }
            finally {
                hibernateSession.close();
                session.close();
            }
        }
    }

    private class RowBuffer {
        private Object[] buffer;
        private int fetchCount;
        private int index = 0;
        private CompassSession compassSession;
        private org.hibernate.Session hibernateSession;

        RowBuffer(CompassSession compassSession, org.hibernate.Session hibernateSession, int fetchCount) {
            this.compassSession = compassSession;
            this.hibernateSession = hibernateSession;
            this.fetchCount = fetchCount;
            this.buffer = new Object[fetchCount + 1];
        }

        public void put(Object row) {
            this.buffer[this.index] = row;
            ++this.index;
        }

        public boolean shouldFlush() {
            return this.index >= this.fetchCount;
        }

        public void close() {
            this.flush();
            this.buffer = null;
        }

        private void flush() {
            for (int i = 0; i < this.index; ++i) {
                this.compassSession.create(this.buffer[i]);
            }
            Arrays.fill(this.buffer, null);
            this.compassSession.evictAll();
            this.hibernateSession.clear();
            this.index = 0;
        }
    }
}

