/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.framing.AMQBody;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.BodyFactory;
import org.wso2.andes.framing.EncodableAMQDataBlock;
import org.wso2.andes.framing.EncodingUtils;

public class AMQFrame
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private final int _channel;
    private final AMQBody _bodyFrame;
    public static final byte FRAME_END_BYTE = -50;

    public AMQFrame(int channel, AMQBody bodyFrame) {
        this._channel = channel;
        this._bodyFrame = bodyFrame;
    }

    public AMQFrame(ByteBuffer in, int channel, long bodySize, BodyFactory bodyFactory) throws AMQFrameDecodingException {
        this._channel = channel;
        this._bodyFrame = bodyFactory.createBody(in, bodySize);
    }

    public long getSize() {
        return 7 + this._bodyFrame.getSize() + 1;
    }

    public static final int getFrameOverhead() {
        return 8;
    }

    public void writePayload(ByteBuffer buffer) {
        buffer.put(this._bodyFrame.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, this._channel);
        EncodingUtils.writeUnsignedInteger(buffer, this._bodyFrame.getSize());
        this._bodyFrame.writePayload(buffer);
        buffer.put((byte)-50);
    }

    public final int getChannel() {
        return this._channel;
    }

    public final AMQBody getBodyFrame() {
        return this._bodyFrame;
    }

    public String toString() {
        return "Frame channelId: " + this._channel + ", bodyFrame: " + String.valueOf(this._bodyFrame);
    }

    public static void writeFrame(ByteBuffer buffer, int channel, AMQBody body) {
        buffer.put(body.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, body.getSize());
        body.writePayload(buffer);
        buffer.put((byte)-50);
    }

    public static void writeFrames(ByteBuffer buffer, int channel, AMQBody body1, AMQBody body2) {
        buffer.put(body1.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, body1.getSize());
        body1.writePayload(buffer);
        buffer.put((byte)-50);
        buffer.put(body2.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, body2.getSize());
        body2.writePayload(buffer);
        buffer.put((byte)-50);
    }

    public static void writeFrames(ByteBuffer buffer, int channel, AMQBody body1, AMQBody body2, AMQBody body3) {
        buffer.put(body1.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, body1.getSize());
        body1.writePayload(buffer);
        buffer.put((byte)-50);
        buffer.put(body2.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, body2.getSize());
        body2.writePayload(buffer);
        buffer.put((byte)-50);
        buffer.put(body3.getFrameType());
        EncodingUtils.writeUnsignedShort(buffer, channel);
        EncodingUtils.writeUnsignedInteger(buffer, body3.getSize());
        body3.writePayload(buffer);
        buffer.put((byte)-50);
    }
}

