/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidProperties {
    private static final Logger _logger = LoggerFactory.getLogger(QpidProperties.class);
    public static final String VERSION_RESOURCE = "qpidversion.properties";
    public static final String PRODUCT_NAME_PROPERTY = "qpid.name";
    public static final String RELEASE_VERSION_PROPERTY = "qpid.version";
    public static final String BUILD_VERSION_PROPERTY = "qpid.svnversion";
    private static final String DEFAULT = "unknown";
    private static String productName = "unknown";
    private static String releaseVersion = "unknown";
    private static String buildVersion = "unknown";

    public static String getProductName() {
        return productName;
    }

    public static String getReleaseVersion() {
        return releaseVersion;
    }

    public static String getBuildVersion() {
        return buildVersion;
    }

    public static String getVersionString() {
        return QpidProperties.getProductName() + " - " + QpidProperties.getReleaseVersion() + " build: " + QpidProperties.getBuildVersion();
    }

    private static String readPropertyValue(Properties props, String propertyName) {
        String retVal = (String)props.get(propertyName);
        if (retVal == null) {
            retVal = DEFAULT;
        }
        return retVal;
    }

    public static void main(String[] args) {
        System.out.println(QpidProperties.getVersionString());
    }

    static {
        Properties props = new Properties();
        try {
            InputStream propertyStream = QpidProperties.class.getClassLoader().getResourceAsStream(VERSION_RESOURCE);
            if (propertyStream == null) {
                _logger.warn("Unable to find resource qpidversion.properties from classloader");
            } else {
                props.load(propertyStream);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Dumping QpidProperties");
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        _logger.debug("Property: " + entry.getKey() + " Value: " + entry.getValue());
                    }
                    _logger.debug("End of property dump");
                }
                productName = QpidProperties.readPropertyValue(props, PRODUCT_NAME_PROPERTY);
                releaseVersion = QpidProperties.readPropertyValue(props, RELEASE_VERSION_PROPERTY);
                buildVersion = QpidProperties.readPropertyValue(props, BUILD_VERSION_PROPERTY);
            }
        }
        catch (IOException e) {
            _logger.error("Could not load version.properties resource: " + e, (Throwable)e);
        }
    }
}

