/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQChannelClosedException;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQInvalidArgumentException;
import org.wso2.andes.AMQInvalidRoutingKeyException;
import org.wso2.andes.client.AMQNoConsumersException;
import org.wso2.andes.client.AMQNoRouteException;
import org.wso2.andes.client.protocol.AMQProtocolSession;
import org.wso2.andes.client.state.StateAwareMethodListener;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ChannelCloseBody;
import org.wso2.andes.framing.ChannelCloseOkBody;
import org.wso2.andes.protocol.AMQConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelCloseMethodHandler
implements StateAwareMethodListener<ChannelCloseBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ChannelCloseMethodHandler.class);
    private static ChannelCloseMethodHandler _handler = new ChannelCloseMethodHandler();

    public static ChannelCloseMethodHandler getInstance() {
        return _handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void methodReceived(AMQProtocolSession session, ChannelCloseBody method, int channelId) throws AMQException {
        _logger.debug("ChannelClose method received");
        AMQConstant errorCode = AMQConstant.getConstant(method.getReplyCode());
        AMQShortString reason = method.getReplyText();
        if (_logger.isDebugEnabled()) {
            _logger.debug("Channel close reply code: " + errorCode + ", reason: " + reason);
        }
        ChannelCloseOkBody body = session.getMethodRegistry().createChannelCloseOkBody();
        AMQFrame frame = body.generateFrame(channelId);
        session.writeFrame(frame);
        try {
            if (errorCode != AMQConstant.REPLY_SUCCESS) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Channel close received with errorCode " + errorCode + ", and reason " + reason);
                }
                if (errorCode == AMQConstant.NO_CONSUMERS) {
                    throw new AMQNoConsumersException("Error: " + reason, null, null);
                }
                if (errorCode == AMQConstant.NO_ROUTE) {
                    throw new AMQNoRouteException("Error: " + reason, null, null);
                }
                if (errorCode == AMQConstant.INVALID_ARGUMENT) {
                    _logger.debug("Broker responded with Invalid Argument.");
                    throw new AMQInvalidArgumentException(String.valueOf(reason), null);
                }
                if (errorCode == AMQConstant.INVALID_ROUTING_KEY) {
                    _logger.debug("Broker responded with Invalid Routing Key.");
                    throw new AMQInvalidRoutingKeyException(String.valueOf(reason), null);
                }
                throw new AMQChannelClosedException(errorCode, "Error: " + reason, null);
            }
        }
        finally {
            session.channelClosed(channelId, errorCode, String.valueOf(reason));
        }
    }
}

