/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;

public final class RemoveBackupOperation
extends KeyBasedMapOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private boolean unlockKey = false;

    public RemoveBackupOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public RemoveBackupOperation(String name, Data dataKey, boolean unlockKey) {
        super(name, dataKey);
        this.unlockKey = unlockKey;
    }

    public RemoveBackupOperation() {
    }

    @Override
    public void run() {
        int partitionId;
        MapService mapService = (MapService)this.getService();
        RecordStore recordStore = mapService.getRecordStore(partitionId = this.getPartitionId(), this.name);
        Record record = recordStore.getRecords().get(this.dataKey);
        if (record != null) {
            recordStore.getRecords().remove(this.dataKey);
        }
        if (this.unlockKey) {
            recordStore.forceUnlock(this.dataKey);
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }
}

