/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import java.io.IOException;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;

public class LibExtractor {
    public static void main(String[] args) {
        System.out.println("Extracting libraries to lib directory...");
        File libDir = new File("lib");
        String temp = "temp-WAR";
        File tempDir = new File(temp);
        if (tempDir.exists()) {
            FileManipulator.deleteDir(tempDir);
        }
        ArchiveManipulator am = new ArchiveManipulator();
        try {
            if (!libDir.mkdirs()) {
                throw new IOException("Fail to create the directory: " + libDir.getAbsolutePath());
            }
            LibExtractor.extract(am, temp, libDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(" Error occurred while copying libs: " + e);
            System.exit(1);
        }
    }

    private static void extract(ArchiveManipulator am, String temp, File libDir) throws IOException {
        am.extract("wso2wsas-war.zip", temp);
        FileManipulator.copyDir(new File(temp + File.separator + "WEB-INF" + File.separator + "lib"), libDir);
        System.out.println("OK");
    }
}

