/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQBody;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQProtocolVersionException;
import org.wso2.andes.framing.BasicContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderProperties;
import org.wso2.andes.framing.ContentHeaderPropertiesFactory;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;

public class ContentHeaderBody
implements AMQBody {
    public static final byte TYPE = 2;
    public int classId;
    public int weight;
    public long bodySize;
    private ContentHeaderProperties properties;
    long totTime = 0L;
    long count = 0L;

    public ContentHeaderBody() {
    }

    public ContentHeaderBody(ByteBuffer buffer, long size) throws AMQFrameDecodingException {
        this.classId = buffer.getUnsignedShort();
        this.weight = buffer.getUnsignedShort();
        this.bodySize = buffer.getLong();
        int propertyFlags = buffer.getUnsignedShort();
        ContentHeaderPropertiesFactory factory = ContentHeaderPropertiesFactory.getInstance();
        this.properties = factory.createContentHeaderProperties(this.classId, propertyFlags, buffer, (int)size - 14);
    }

    public ContentHeaderBody(ContentHeaderProperties props, int classId) {
        this.properties = props;
        this.classId = classId;
    }

    public ContentHeaderBody(int classId, int weight, ContentHeaderProperties props, long bodySize) {
        this(props, classId);
        this.weight = weight;
        this.bodySize = bodySize;
    }

    public byte getFrameType() {
        return 2;
    }

    protected void populateFromBuffer(ByteBuffer buffer, long size) throws AMQFrameDecodingException, AMQProtocolVersionException {
        this.classId = buffer.getUnsignedShort();
        this.weight = buffer.getUnsignedShort();
        this.bodySize = buffer.getLong();
        int propertyFlags = buffer.getUnsignedShort();
        ContentHeaderPropertiesFactory factory = ContentHeaderPropertiesFactory.getInstance();
        this.properties = factory.createContentHeaderProperties(this.classId, propertyFlags, buffer, (int)size - 14);
    }

    public static ContentHeaderBody createFromBuffer(ByteBuffer buffer, long size) throws AMQFrameDecodingException, AMQProtocolVersionException {
        ContentHeaderBody body = new ContentHeaderBody(buffer, size);
        return body;
    }

    public int getSize() {
        return 14 + this.properties.getPropertyListSize();
    }

    public void writePayload(ByteBuffer buffer) {
        EncodingUtils.writeUnsignedShort(buffer, this.classId);
        EncodingUtils.writeUnsignedShort(buffer, this.weight);
        buffer.putLong(this.bodySize);
        EncodingUtils.writeUnsignedShort(buffer, this.properties.getPropertyFlags());
        this.properties.writePropertyListPayload(buffer);
    }

    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        long start = System.nanoTime();
        session.contentHeaderReceived(channelId, this);
        this.totTime += (System.nanoTime() - start) / 1000000L;
        ++this.count;
        if (this.count % 100L == 0L) {
            System.out.println("Content Header Body contentHeaderReceived took " + this.totTime / this.count + " ms ");
        }
    }

    public static AMQFrame createAMQFrame(int channelId, int classId, int weight, BasicContentHeaderProperties properties, long bodySize) {
        return new AMQFrame(channelId, new ContentHeaderBody(classId, weight, properties, bodySize));
    }

    public static AMQFrame createAMQFrame(int channelId, ContentHeaderBody body) {
        return new AMQFrame(channelId, body);
    }

    public ContentHeaderProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ContentHeaderProperties props) {
        this.properties = props;
    }
}

