/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.haproxy.extension;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.stratos.common.threading.StratosThreadPool;
import org.apache.stratos.haproxy.extension.HAProxy;
import org.apache.stratos.haproxy.extension.HAProxyContext;
import org.apache.stratos.haproxy.extension.HAProxyStatisticsReader;
import org.apache.stratos.load.balancer.common.statistics.LoadBalancerStatisticsReader;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;
import org.apache.stratos.load.balancer.extension.api.LoadBalancer;
import org.apache.stratos.load.balancer.extension.api.LoadBalancerExtension;

public class Main {
    private static final Log log = LogFactory.getLog(Main.class);
    private static ExecutorService executorService;

    public static void main(String[] args) {
        block4: {
            LoadBalancerExtension extension = null;
            try {
                PropertyConfigurator.configure((String)System.getProperty("log4j.properties.file.path"));
                if (log.isInfoEnabled()) {
                    log.info((Object)"HAProxy extension started");
                }
                final Thread mainThread = Thread.currentThread();
                final LoadBalancerExtension finalExtension = extension;
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (finalExtension != null) {
                                log.info((Object)"Shutting haproxy instance...");
                                finalExtension.stop();
                            }
                            mainThread.join();
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                });
                executorService = StratosThreadPool.getExecutorService((String)"haproxy.extension.thread.pool", (int)10);
                HAProxyContext.getInstance().validate();
                TopologyProvider topologyProvider = new TopologyProvider();
                HAProxyStatisticsReader statisticsReader = HAProxyContext.getInstance().isCEPStatsPublisherEnabled() ? new HAProxyStatisticsReader(topologyProvider) : null;
                extension = new LoadBalancerExtension((LoadBalancer)new HAProxy(), (LoadBalancerStatisticsReader)statisticsReader, topologyProvider);
                extension.setExecutorService(executorService);
                extension.execute();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)e);
                }
                if (extension == null) break block4;
                log.info((Object)"Shutting haproxy instance...");
                extension.stop();
            }
        }
    }
}

