/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ClusterCreatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyApplicationFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.topology.updater.TopologyUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ClusterCreatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ClusterCreatedEvent event = (ClusterCreatedEvent)MessagingUtil.jsonToObject(message, ClusterCreatedEvent.class);
            String serviceName = event.getCluster().getServiceName();
            TopologyUpdater.acquireWriteLockForService(serviceName);
            try {
                boolean bl = this.doProcess(event, topology);
                return bl;
            }
            finally {
                TopologyUpdater.releaseWriteLockForService(serviceName);
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ClusterCreatedEvent event, Topology topology) {
        Cluster cluster = event.getCluster();
        String applicationId = cluster.getAppId();
        String serviceName = cluster.getServiceName();
        String clusterId = cluster.getClusterId();
        if (TopologyApplicationFilter.apply(applicationId)) {
            return false;
        }
        if (TopologyServiceFilter.apply(serviceName)) {
            return false;
        }
        if (TopologyClusterFilter.apply(clusterId)) {
            return false;
        }
        Service service = topology.getService(serviceName);
        if (service == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Service does not exist: [service] %s", serviceName));
            }
            return false;
        }
        if (service.clusterExists(clusterId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cluster already exists in service: [service] %s [cluster] %s", serviceName, clusterId));
            }
        } else {
            service.addCluster(cluster);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Cluster created: %s", cluster.toString()));
            }
        }
        this.notifyEventListeners(event);
        return true;
    }
}

