/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.event.application.ApplicationDeletedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationDeletedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationDeletedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationDeletedEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationDeletedEvent event = (ApplicationDeletedEvent)MessagingUtil.jsonToObject(message, ApplicationDeletedEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to ApplicationDeletedEvent");
                return false;
            }
            ApplicationsUpdater.acquireWriteLockForApplications();
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplications();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationDeletedEvent event, Applications applications) {
        if (event.getAppId() == null || event.getAppId().isEmpty()) {
            String errorMsg = "App id of application deleted event is invalid: [ " + event.getAppId() + " ]";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        applications.removeApplication(event.getAppId());
        this.notifyEventListeners(event);
        if (log.isInfoEnabled()) {
            log.info((Object)("[Application] " + event.getAppId() + " has been successfully removed"));
        }
        return true;
    }
}

