/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor;

import java.util.LinkedList;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessor;

public abstract class MessageProcessorChain {
    private LinkedList<MessageProcessor> list = new LinkedList();

    public MessageProcessorChain() {
        this.initialize();
    }

    protected abstract void initialize();

    public abstract void addEventListener(EventListener var1);

    public void add(MessageProcessor messageProcessor) {
        if (this.list.size() > 0) {
            this.list.getLast().setNext(messageProcessor);
        }
        this.list.add(messageProcessor);
    }

    public void removeLast() {
        this.list.removeLast();
        if (this.list.size() > 0) {
            this.list.getLast().setNext(null);
        }
    }

    public boolean process(String type, String message, Object object) {
        MessageProcessor root = this.list.getFirst();
        if (root == null) {
            throw new RuntimeException("Message processor chain is not initialized");
        }
        return root.process(type, message, object);
    }
}

