/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.filter.topology;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.filter.MessageFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;

public class TopologyApplicationFilter
extends MessageFilter {
    private static final Log log = LogFactory.getLog(TopologyServiceFilter.class);
    public static final String TOPOLOGY_APPLICATION_FILTER_APPLICATION_ID = "application-id";
    private static volatile TopologyApplicationFilter instance;

    public TopologyApplicationFilter() {
        super("stratos.topology.application.filter");
    }

    public static boolean apply(String applicationId) {
        boolean excluded = false;
        if (TopologyApplicationFilter.getInstance().isActive()) {
            if (StringUtils.isNotBlank((CharSequence)applicationId) && TopologyApplicationFilter.getInstance().applicationExcluded(applicationId)) {
                excluded = true;
            }
            if (excluded && log.isInfoEnabled()) {
                log.info((Object)String.format("Application is excluded: [application-id] %s", applicationId));
            }
        }
        return excluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyApplicationFilter getInstance() {
        if (instance != null) return instance;
        Class<TopologyApplicationFilter> clazz = TopologyApplicationFilter.class;
        synchronized (TopologyApplicationFilter.class) {
            if (instance != null) return instance;
            instance = new TopologyApplicationFilter();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"Topology application filter instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean applicationExcluded(String value) {
        return this.excluded(TOPOLOGY_APPLICATION_FILTER_APPLICATION_ID, value);
    }

    private Collection<String> getIncludedApplicationIds() {
        return this.getIncludedPropertyValues(TOPOLOGY_APPLICATION_FILTER_APPLICATION_ID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("application-id=");
        for (String applicationId : TopologyApplicationFilter.getInstance().getIncludedApplicationIds()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(applicationId);
        }
        return sb.toString();
    }
}

