/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect.amqp;

import java.io.File;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicConnector;
import org.apache.stratos.messaging.domain.exception.MessagingException;
import org.apache.stratos.messaging.util.MessagingUtil;
import org.wso2.carbon.utils.CarbonUtils;

public abstract class AmqpTopicConnector
implements TopicConnector {
    private static final Log log = LogFactory.getLog(AmqpTopicConnector.class);
    private TopicConnectionFactory connectionFactory;
    private TopicConnection topicConnection;
    private InitialContext initialContext;

    @Override
    public void create() {
        try {
            String jndiPropFileDir = System.getProperty("jndi.properties.dir");
            if (StringUtils.isEmpty((CharSequence)jndiPropFileDir)) {
                jndiPropFileDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf";
            }
            Properties environment = MessagingUtil.getProperties(jndiPropFileDir + File.separator + "jndi.properties");
            environment.put("org.wso2.carbon.context.RequestBaseContext", "true");
            this.initialContext = new InitialContext(environment);
            String connectionFactoryName = environment.get("connectionfactoryName").toString();
            this.connectionFactory = (TopicConnectionFactory)this.initialContext.lookup(connectionFactoryName);
        }
        catch (Exception e) {
            String message = "Could not create topic connector";
            log.error((Object)message, (Throwable)e);
            throw new MessagingException(message, e);
        }
    }

    @Override
    public String getServerURI() {
        return "";
    }

    @Override
    public void connect() {
        try {
            this.topicConnection = this.connectionFactory.createTopicConnection();
            this.topicConnection.setExceptionListener(new ExceptionListener(){

                public void onException(JMSException e) {
                    log.warn((Object)"Connection to the message broker failed");
                    AmqpTopicConnector.this.reconnect();
                }
            });
            this.topicConnection.start();
        }
        catch (JMSException e) {
            String message = "Could not connect to message broker";
            log.error((Object)message, (Throwable)e);
            throw new MessagingException(message, e);
        }
    }

    @Override
    public void disconnect() {
        if (this.topicConnection != null) {
            try {
                this.topicConnection.stop();
                this.topicConnection.close();
            }
            catch (JMSException ignore) {
                log.warn((Object)"Could not disconnect from message broker");
            }
        }
    }

    public TopicSession newSession() throws Exception {
        return this.topicConnection.createTopicSession(false, 1);
    }

    public Topic lookupTopic(String topicName) {
        try {
            return (Topic)this.initialContext.lookup(topicName);
        }
        catch (NamingException ignore) {
            return null;
        }
    }

    protected abstract void reconnect();
}

