/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect;

import org.apache.stratos.messaging.broker.connect.TopicSubscriber;
import org.apache.stratos.messaging.broker.connect.amqp.AmqpTopicSubscriber;
import org.apache.stratos.messaging.broker.connect.mqtt.MqttTopicSubscriber;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;

public class TopicSubscriberFactory {
    public static TopicSubscriber createTopicSubscriber(String protocol, MessageListener messageListener, String topicName) {
        if ("amqp".equals(protocol)) {
            return new AmqpTopicSubscriber(messageListener, topicName);
        }
        if ("mqtt".equals(protocol)) {
            return new MqttTopicSubscriber(messageListener, topicName);
        }
        throw new RuntimeException("Could not create topic subscriber, unknown protocol: " + protocol);
    }
}

