/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.utils;

import java.net.MalformedURLException;
import java.net.URL;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;

public class AgentServerURL {
    private ReceiverConfiguration.Protocol protocol;
    private String host;
    private int port;
    private boolean isSecured = false;

    public AgentServerURL(String url) throws MalformedURLException {
        URL theUrl;
        if (url.startsWith("http:")) {
            this.protocol = ReceiverConfiguration.Protocol.HTTP;
            theUrl = new URL(url);
            this.isSecured = false;
        } else if (url.startsWith("https:")) {
            this.protocol = ReceiverConfiguration.Protocol.HTTP;
            theUrl = new URL(url);
            this.isSecured = true;
        } else if (url.startsWith("tcp:")) {
            theUrl = new URL(url.replaceFirst("tcp", "http"));
            this.protocol = ReceiverConfiguration.Protocol.TCP;
            this.isSecured = false;
        } else if (url.startsWith("ssl:")) {
            this.protocol = ReceiverConfiguration.Protocol.TCP;
            theUrl = new URL(url.replaceFirst("ssl", "http"));
            this.isSecured = true;
        } else {
            throw new MalformedURLException("The url protocol is not tcp or ssl " + url);
        }
        this.host = theUrl.getHost();
        this.port = theUrl.getPort();
    }

    public ReceiverConfiguration.Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ReceiverConfiguration.Protocol protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecured() {
        return this.isSecured;
    }

    public void setSecured(boolean secured) {
        this.isSecured = secured;
    }
}

