/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.publisher.client;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.wso2.carbon.databridge.agent.thrift.conf.DataPublisherConfiguration;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.exception.EventPublisherException;
import org.wso2.carbon.databridge.agent.thrift.internal.EventQueue;
import org.wso2.carbon.databridge.agent.thrift.internal.publisher.authenticator.AgentAuthenticator;
import org.wso2.carbon.databridge.agent.thrift.lb.ReceiverStateObserver;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.SessionTimeoutException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.exception.UndefinedEventTypeException;
import org.wso2.carbon.databridge.commons.thrift.data.ThriftEventBundle;

public abstract class EventPublisher
implements Runnable {
    private static Log log = LogFactory.getLog(EventPublisher.class);
    private EventQueue<Event> eventQueue;
    private GenericKeyedObjectPool transportPool;
    private Semaphore queueSemaphore;
    private int maxMessageBundleSize;
    private DataPublisherConfiguration dataPublisherConfiguration;
    private AgentAuthenticator agentAuthenticator;
    private ThreadPoolExecutor threadPool;
    private ReceiverStateObserver receiverStateObserver;

    public EventPublisher(EventQueue<Event> eventQueue, GenericKeyedObjectPool transportPool, Semaphore queueSemaphore, int maxMessageBundleSize, DataPublisherConfiguration dataPublisherConfiguration, AgentAuthenticator agentAuthenticator, ThreadPoolExecutor threadPool) {
        this.eventQueue = eventQueue;
        this.transportPool = transportPool;
        this.queueSemaphore = queueSemaphore;
        this.maxMessageBundleSize = maxMessageBundleSize;
        this.dataPublisherConfiguration = dataPublisherConfiguration;
        this.agentAuthenticator = agentAuthenticator;
        this.threadPool = threadPool;
    }

    public void registerReceiverStateObserver(ReceiverStateObserver stateObserver) {
        if (null == this.receiverStateObserver) {
            this.receiverStateObserver = stateObserver;
        }
    }

    @Override
    public void run() {
        block5: {
            Event event;
            ArrayList<Object> tempEventBundleHolder = null;
            ThriftEventBundle eventBundle = null;
            if (null != this.receiverStateObserver) {
                tempEventBundleHolder = new ArrayList<Event>();
            }
            while ((event = this.eventQueue.poll()) != null) {
                this.queueSemaphore.release();
                if (null != tempEventBundleHolder) {
                    tempEventBundleHolder.add(event);
                }
                if (this.getNumberOfEvents(eventBundle = this.convertToEventBundle(eventBundle, event, this.dataPublisherConfiguration.getSessionId())) < this.maxMessageBundleSize) continue;
                this.publishEvent(eventBundle, tempEventBundleHolder);
                if (null != this.receiverStateObserver) {
                    tempEventBundleHolder = new ArrayList();
                }
                if (this.threadPool.getActiveCount() < this.threadPool.getCorePoolSize()) {
                    eventBundle = null;
                    continue;
                }
                this.threadPool.submit(this);
                break block5;
            }
            if (eventBundle == null) break block5;
            this.publishEvent(eventBundle, tempEventBundleHolder);
        }
    }

    private void publishEvent(Object eventBundle, ArrayList<Event> tempEventBundleHolder) {
        Object client = null;
        try {
            client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
            this.setSessionId(eventBundle, this.dataPublisherConfiguration.getSessionId());
            this.publish(client, eventBundle);
            this.returnClient(client);
        }
        catch (AgentException e) {
            this.discardClient();
            this.notifyConnectionFailure(tempEventBundleHolder);
            log.error((Object)("Cannot get a client to send events to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            this.setSessionId(eventBundle, this.reconnect(this.getSessionId(eventBundle)));
            this.republish(client, eventBundle, tempEventBundleHolder);
        }
        catch (UndefinedEventTypeException e) {
            log.error((Object)("Wrongly typed event " + eventBundle + " sent to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
            this.returnClient(client);
        }
        catch (EventPublisherException e) {
            this.discardClient();
            this.notifyConnectionFailure(tempEventBundleHolder);
            log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
        }
    }

    private void republish(Object client, Object eventBundle, ArrayList<Event> tempEventBundleHolder) {
        try {
            this.publish(client, eventBundle);
            this.returnClient(client);
        }
        catch (EventPublisherException e) {
            this.discardClient();
            log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)e);
            this.notifyConnectionFailure(tempEventBundleHolder);
        }
        catch (SessionTimeoutException e) {
            this.discardClient();
            log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)e);
        }
        catch (UndefinedEventTypeException e) {
            log.error((Object)("Wrongly typed event " + eventBundle.toString() + " sent  to " + this.dataPublisherConfiguration.getPublisherKey()), (Throwable)e);
            this.returnClient(client);
        }
    }

    private void notifyConnectionFailure(ArrayList<Event> tempEventBundleHolder) {
        if (null != this.receiverStateObserver) {
            ReceiverConfiguration conf = this.dataPublisherConfiguration.getReceiverConfiguration();
            StringBuilder url = new StringBuilder(conf.getDataReceiverProtocol().toString());
            url.append("://");
            url.append(conf.getDataReceiverIp());
            url.append(":");
            url.append(conf.getDataReceiverPort());
            this.receiverStateObserver.notifyConnectionFailure(url.toString(), conf.getUserName(), conf.getPassword());
            if (null != this.eventQueue) {
                LinkedBlockingQueue<Event> events = this.eventQueue.getAndResetQueue();
                if (null != tempEventBundleHolder) {
                    for (Event event : tempEventBundleHolder) {
                        try {
                            events.put(event);
                        }
                        catch (InterruptedException ignore) {
                            log.error((Object)"Error while populating resend events list", (Throwable)ignore);
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("resending events size: " + events.size() + "in thread id :" + Thread.currentThread().getId()));
                }
                this.receiverStateObserver.resendEvents(events);
            }
        }
    }

    protected abstract int getNumberOfEvents(Object var1);

    protected abstract ThriftEventBundle convertToEventBundle(Object var1, Event var2, String var3);

    protected abstract void setSessionId(Object var1, String var2);

    protected abstract String getSessionId(Object var1);

    abstract void publish(Object var1, Object var2) throws UndefinedEventTypeException, SessionTimeoutException, EventPublisherException;

    public String defineStream(String sessionId, String streamDefinition) throws AgentException, DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, StreamDefinitionException {
        String currentSessionId = sessionId;
        String streamId = null;
        Object client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
        try {
            streamId = this.defineStream(client, currentSessionId, streamDefinition);
            this.returnClient(client);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            currentSessionId = this.reconnect(currentSessionId);
            streamId = this.redefineStream(client, streamDefinition, currentSessionId);
        }
        catch (StreamDefinitionException e) {
            this.returnClient(client);
            throw new StreamDefinitionException("Invalid type definition for stream " + streamDefinition, (Throwable)e);
        }
        catch (EventPublisherException e) {
            this.discardClient();
            this.notifyConnectionFailure(null);
            throw new AgentException("Cannot define type " + streamDefinition, e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            this.returnClient(client);
            throw new DifferentStreamDefinitionAlreadyDefinedException("Same stream id with different definition already defined before sending this event definitions to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)e);
        }
        catch (MalformedStreamDefinitionException e) {
            this.returnClient(client);
            throw new MalformedStreamDefinitionException("Malformed event definition :" + streamDefinition + " send  to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)e);
        }
        return streamId;
    }

    private String redefineStream(Object client, String streamDefinition, String currentSessionId) throws DifferentStreamDefinitionAlreadyDefinedException, StreamDefinitionException, MalformedStreamDefinitionException {
        String streamId = null;
        try {
            streamId = this.defineStream(client, currentSessionId, streamDefinition);
            this.returnClient(client);
            return streamId;
        }
        catch (SessionTimeoutException ex) {
            log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            this.discardClient();
            return null;
        }
        catch (EventPublisherException ex) {
            log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            this.discardClient();
            this.notifyConnectionFailure(null);
            return null;
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException ex) {
            this.returnClient(client);
            throw new DifferentStreamDefinitionAlreadyDefinedException("Type already defined when send event definitions to" + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)ex);
        }
        catch (StreamDefinitionException ex) {
            this.returnClient(client);
            throw new StreamDefinitionException("Wrongly defined event definition after reconnection  :" + streamDefinition + " sent to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)ex);
        }
        catch (MalformedStreamDefinitionException ex) {
            this.returnClient(client);
            throw new MalformedStreamDefinitionException("Malformed event definition after reconnection  :" + streamDefinition + " sent to " + this.dataPublisherConfiguration.getPublisherKey(), (Throwable)ex);
        }
    }

    protected abstract String defineStream(Object var1, String var2, String var3) throws DifferentStreamDefinitionAlreadyDefinedException, MalformedStreamDefinitionException, EventPublisherException, SessionTimeoutException, StreamDefinitionException;

    public String findStreamId(String sessionId, String name, String version) throws AgentException {
        String currentSessionId = sessionId;
        String streamId = null;
        Object client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
        try {
            streamId = this.findStreamId(client, currentSessionId, name, version);
            this.returnClient(client);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            currentSessionId = this.reconnect(currentSessionId);
            try {
                streamId = this.findStreamId(client, currentSessionId, name, version);
                this.returnClient(client);
            }
            catch (SessionTimeoutException ex) {
                this.discardClient();
                log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            }
            catch (EventPublisherException ex) {
                this.discardClient();
                log.error((Object)("Cannot send events to " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
                this.notifyConnectionFailure(null);
            }
        }
        catch (EventPublisherException e) {
            this.discardClient();
            this.notifyConnectionFailure(null);
            throw new AgentException("Error when finding event stream definition for : " + name + " " + version, e);
        }
        return streamId;
    }

    protected abstract String findStreamId(Object var1, String var2, String var3, String var4) throws SessionTimeoutException, EventPublisherException;

    public boolean deleteStream(String sessionId, String streamId) throws AgentException {
        String currentSessionId = sessionId;
        Object client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
        boolean status = false;
        try {
            status = this.deleteStream(client, currentSessionId, streamId);
            this.returnClient(client);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            currentSessionId = this.reconnect(currentSessionId);
            try {
                status = this.deleteStream(client, currentSessionId, streamId);
                this.returnClient(client);
            }
            catch (EventPublisherException ex) {
                this.discardClient();
                log.error((Object)("Cannot delete stream " + streamId + " at " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
                this.notifyConnectionFailure(null);
            }
            catch (SessionTimeoutException ex) {
                this.discardClient();
                log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            }
        }
        catch (EventPublisherException e) {
            this.discardClient();
            this.notifyConnectionFailure(null);
            throw new AgentException("Error when deleting event stream of: " + streamId, e);
        }
        return status;
    }

    protected abstract boolean deleteStream(Object var1, String var2, String var3) throws EventPublisherException, SessionTimeoutException;

    public boolean deleteStream(String sessionId, String streamName, String streamVersion) throws AgentException {
        String currentSessionId = sessionId;
        Object client = this.getClient(this.dataPublisherConfiguration.getPublisherKey());
        boolean status = false;
        try {
            status = this.deleteStream(client, currentSessionId, streamName, streamVersion);
            this.returnClient(client);
        }
        catch (SessionTimeoutException e) {
            log.info((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + "," + e.getMessage()));
            currentSessionId = this.reconnect(currentSessionId);
            try {
                status = this.deleteStream(client, currentSessionId, streamName, streamVersion);
                this.returnClient(client);
            }
            catch (EventPublisherException ex) {
                this.discardClient();
                log.error((Object)("Cannot delete stream " + streamName + " " + streamVersion + " at " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
                this.notifyConnectionFailure(null);
            }
            catch (SessionTimeoutException ex) {
                this.discardClient();
                log.error((Object)("Session timed out for " + this.dataPublisherConfiguration.getPublisherKey() + " even after reconnecting "), (Throwable)ex);
            }
        }
        catch (EventPublisherException e) {
            this.discardClient();
            this.notifyConnectionFailure(null);
            throw new AgentException("Error when deleting event stream of: " + streamName + " " + streamVersion, e);
        }
        return status;
    }

    protected abstract boolean deleteStream(Object var1, String var2, String var3, String var4) throws EventPublisherException, SessionTimeoutException;

    private String reconnect(String currentSessionId) {
        this.attemptReconnection(3, currentSessionId);
        return this.dataPublisherConfiguration.getSessionId();
    }

    public synchronized void attemptReconnection(int reconnectionTime, String sessionId) {
        if (!this.dataPublisherConfiguration.getSessionId().equals(sessionId)) {
            return;
        }
        if (reconnectionTime > 0) {
            try {
                this.dataPublisherConfiguration.setSessionId(this.agentAuthenticator.connect(this.dataPublisherConfiguration));
            }
            catch (AuthenticationException e) {
                log.error((Object)(this.dataPublisherConfiguration.getReceiverConfiguration().getUserName() + " not authorised to access server at " + this.dataPublisherConfiguration.getPublisherKey()));
            }
            catch (TransportException e) {
                this.attemptReconnection(reconnectionTime - 1, sessionId);
            }
            catch (AgentException e) {
                this.attemptReconnection(reconnectionTime - 1, sessionId);
            }
        }
    }

    private Object getClient(String publisherKey) throws AgentException {
        try {
            return this.transportPool.borrowObject((Object)publisherKey);
        }
        catch (Exception e) {
            this.notifyConnectionFailure(null);
            throw new AgentException("Cannot borrow client for " + publisherKey, e);
        }
    }

    private void returnClient(Object client) {
        try {
            this.transportPool.returnObject((Object)this.dataPublisherConfiguration.getPublisherKey(), client);
        }
        catch (Exception e) {
            this.notifyConnectionFailure(null);
            log.warn((Object)"Error occurred while returning object to connection pool", (Throwable)e);
            this.discardClient();
        }
    }

    private void discardClient() {
        this.transportPool.clear((Object)this.dataPublisherConfiguration.getPublisherKey());
    }
}

