/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal.pool.client.general;

import java.net.SocketException;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.databridge.agent.thrift.conf.ReceiverConfiguration;
import org.wso2.carbon.databridge.commons.thrift.service.general.ThriftEventTransmissionService;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;

public class ClientPoolFactory
extends BaseKeyedPoolableObjectFactory {
    public ThriftEventTransmissionService.Client makeObject(Object key) throws TTransportException {
        String[] keyElements = key.toString().split(",");
        if (keyElements[0].equals(ReceiverConfiguration.Protocol.TCP.toString())) {
            String[] hostNameAndPort = keyElements[1].split(":");
            TSocket receiverTransport = null;
            try {
                receiverTransport = new TSocket(HostAddressFinder.findAddress((String)hostNameAndPort[0]), Integer.parseInt(hostNameAndPort[1]));
            }
            catch (SocketException ignored) {
                // empty catch block
            }
            TBinaryProtocol protocol = new TBinaryProtocol(receiverTransport);
            ThriftEventTransmissionService.Client client = new ThriftEventTransmissionService.Client((TProtocol)protocol);
            receiverTransport.open();
            return client;
        }
        THttpClient client = new THttpClient("http://" + keyElements[1] + "/thriftReceiver");
        TCompactProtocol protocol = new TCompactProtocol((TTransport)client);
        ThriftEventTransmissionService.Client publisherClient = new ThriftEventTransmissionService.Client((TProtocol)protocol);
        client.open();
        return publisherClient;
    }

    public boolean validateObject(Object key, Object obj) {
        ThriftEventTransmissionService.Client client = (ThriftEventTransmissionService.Client)obj;
        return client.getOutputProtocol().getTransport().isOpen();
    }
}

