/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.extension.api;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.domain.Service;
import org.apache.stratos.load.balancer.common.domain.Topology;
import org.apache.stratos.load.balancer.common.event.receivers.LoadBalancerCommonApplicationSignUpEventReceiver;
import org.apache.stratos.load.balancer.common.event.receivers.LoadBalancerCommonDomainMappingEventReceiver;
import org.apache.stratos.load.balancer.common.event.receivers.LoadBalancerCommonTopologyEventReceiver;
import org.apache.stratos.load.balancer.common.statistics.LoadBalancerStatisticsReader;
import org.apache.stratos.load.balancer.common.statistics.notifier.LoadBalancerStatisticsNotifier;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;
import org.apache.stratos.load.balancer.extension.api.LoadBalancer;
import org.apache.stratos.load.balancer.extension.api.exception.LoadBalancerExtensionException;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.topology.ClusterRemovedEventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberMaintenanceListener;
import org.apache.stratos.messaging.listener.topology.MemberSuspendedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.listener.topology.ServiceRemovedEventListener;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyMemberFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;

public class LoadBalancerExtension {
    private static final Log log = LogFactory.getLog(LoadBalancerExtension.class);
    private LoadBalancer loadBalancer;
    private LoadBalancerStatisticsReader statsReader;
    private boolean loadBalancerStarted;
    private LoadBalancerStatisticsNotifier statisticsNotifier;
    private ExecutorService executorService;
    private TopologyProvider topologyProvider;
    private LoadBalancerCommonTopologyEventReceiver topologyEventReceiver;
    private LoadBalancerCommonDomainMappingEventReceiver domainMappingEventReceiver;
    private LoadBalancerCommonApplicationSignUpEventReceiver applicationSignUpEventReceiver;

    public LoadBalancerExtension(LoadBalancer loadBalancer, LoadBalancerStatisticsReader statsReader, TopologyProvider topologyProvider) {
        this.loadBalancer = loadBalancer;
        this.statsReader = statsReader;
        this.topologyProvider = topologyProvider;
    }

    public void execute() {
        block6: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Load balancer extension started");
                }
                this.startTopologyEventReceiver(this.executorService, this.topologyProvider);
                this.startApplicationSignUpEventReceiver(this.executorService, this.topologyProvider);
                this.startDomainMappingEventReceiver(this.executorService, this.topologyProvider);
                if (this.statsReader != null) {
                    this.statisticsNotifier = new LoadBalancerStatisticsNotifier(this.statsReader, this.topologyProvider);
                    Thread statsNotifierThread = new Thread((Runnable)this.statisticsNotifier);
                    statsNotifierThread.start();
                } else if (log.isWarnEnabled()) {
                    log.warn((Object)"Load balancer statistics reader not found");
                }
                log.info((Object)"Waiting for complete topology event...");
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Could not start load balancer extension", (Throwable)e);
            }
        }
    }

    private void startTopologyEventReceiver(ExecutorService executorService, TopologyProvider topologyProvider) {
        this.topologyEventReceiver = new LoadBalancerCommonTopologyEventReceiver(topologyProvider);
        this.addTopologyEventListeners(this.topologyEventReceiver);
        this.topologyEventReceiver.setExecutorService(executorService);
        this.topologyEventReceiver.execute();
        if (log.isInfoEnabled()) {
            log.info((Object)"Topology receiver thread started");
        }
        if (log.isInfoEnabled()) {
            if (TopologyServiceFilter.getInstance().isActive()) {
                log.info((Object)String.format("Service filter activated: [filter] %s", TopologyServiceFilter.getInstance().toString()));
            }
            if (TopologyClusterFilter.getInstance().isActive()) {
                log.info((Object)String.format("Cluster filter activated: [filter] %s", TopologyClusterFilter.getInstance().toString()));
            }
            if (TopologyMemberFilter.getInstance().isActive()) {
                log.info((Object)String.format("Member filter activated: [filter] %s", TopologyMemberFilter.getInstance().toString()));
            }
        }
    }

    private void startDomainMappingEventReceiver(ExecutorService executorService, TopologyProvider topologyProvider) {
        this.domainMappingEventReceiver = new LoadBalancerCommonDomainMappingEventReceiver(topologyProvider);
        this.domainMappingEventReceiver.setExecutorService(executorService);
        this.domainMappingEventReceiver.execute();
        if (log.isInfoEnabled()) {
            log.info((Object)"Domain mapping event receiver thread started");
        }
    }

    private void startApplicationSignUpEventReceiver(ExecutorService executorService, TopologyProvider topologyProvider) {
        this.applicationSignUpEventReceiver = new LoadBalancerCommonApplicationSignUpEventReceiver(topologyProvider);
        this.applicationSignUpEventReceiver.setExecutorService(executorService);
        this.applicationSignUpEventReceiver.execute();
        if (log.isInfoEnabled()) {
            log.info((Object)"Application signup event receiver thread started");
        }
    }

    private void addTopologyEventListeners(LoadBalancerCommonTopologyEventReceiver topologyEventReceiver) {
        topologyEventReceiver.addEventListener((EventListener)new CompleteTopologyEventListener(){

            protected void onEvent(Event event) {
                try {
                    if (!LoadBalancerExtension.this.loadBalancerStarted) {
                        LoadBalancerExtension.this.configureAndStart();
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Could not start load balancer", (Throwable)e);
                    }
                    LoadBalancerExtension.this.stop();
                }
            }
        });
        topologyEventReceiver.addEventListener((EventListener)new MemberActivatedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        topologyEventReceiver.addEventListener((EventListener)new MemberSuspendedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        topologyEventReceiver.addEventListener((EventListener)new MemberTerminatedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        topologyEventReceiver.addEventListener((EventListener)new ClusterRemovedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        topologyEventReceiver.addEventListener((EventListener)new ServiceRemovedEventListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
        topologyEventReceiver.addEventListener((EventListener)new MemberMaintenanceListener(){

            protected void onEvent(Event event) {
                LoadBalancerExtension.this.reloadConfiguration();
            }
        });
    }

    private void configureAndStart() throws LoadBalancerExtensionException {
        Topology topology;
        if (!this.topologyEventReceiver.isInitialized()) {
            this.topologyEventReceiver.initializeTopology();
        }
        if (this.topologyPopulated(topology = this.topologyProvider.getTopology()) && this.loadBalancer.configure(topology)) {
            this.loadBalancer.start();
            this.loadBalancerStarted = true;
        }
    }

    private void configureAndReload() throws LoadBalancerExtensionException {
        if (this.loadBalancer.configure(this.topologyProvider.getTopology())) {
            this.loadBalancer.reload();
        }
    }

    private boolean topologyPopulated(Topology topology) {
        for (Service service : topology.getServices()) {
            for (Cluster cluster : service.getClusters()) {
                if (cluster.getMembers().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void reloadConfiguration() {
        block4: {
            try {
                if (!this.loadBalancerStarted) {
                    this.configureAndStart();
                } else {
                    this.configureAndReload();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not reload load balancer configuration", (Throwable)e);
            }
        }
    }

    public void stop() {
        try {
            if (this.topologyEventReceiver != null) {
                this.topologyEventReceiver.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            if (this.statisticsNotifier != null) {
                this.statisticsNotifier.terminate();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.loadBalancer.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

