/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractJTATransaction;
import org.compass.core.transaction.JTASyncTransactionFactory;
import org.compass.core.transaction.TransactionFactory;

public class JTASyncTransaction
extends AbstractJTATransaction {
    private boolean commitBeforeCompletion;

    public JTASyncTransaction(UserTransaction ut, boolean commitBeforeCompletion, TransactionFactory transactionFactory) {
        super(ut, transactionFactory);
        this.commitBeforeCompletion = commitBeforeCompletion;
    }

    protected void doBindToTransaction(Transaction tx, InternalCompassSession session, boolean newTransaction) throws Exception {
        tx.registerSynchronization((Synchronization)new JTATransactionSynchronization(session, tx, newTransaction, this.commitBeforeCompletion, this.transactionFactory));
    }

    private static class JTATransactionSynchronization
    implements Synchronization {
        private static final Log log = LogFactory.getLog(JTATransactionSynchronization.class);
        private InternalCompassSession session;
        private Transaction tx;
        private boolean compassControlledJtaTransaction;
        private boolean commitBeforeCompletion;
        private TransactionFactory transactionFactory;

        public JTATransactionSynchronization(InternalCompassSession session, Transaction tx, boolean compassControlledJtaTransaction, boolean commitBeforeCompletion, TransactionFactory transactionFactory) {
            this.session = session;
            this.tx = tx;
            this.compassControlledJtaTransaction = compassControlledJtaTransaction;
            this.commitBeforeCompletion = commitBeforeCompletion;
            this.transactionFactory = transactionFactory;
        }

        public void beforeCompletion() {
            if (!this.commitBeforeCompletion) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing compass transaction using JTA synchronization beforeCompletion on thread [" + Thread.currentThread().getName() + "]"));
            }
            this.session.getSearchEngine().commit(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                if (!this.commitBeforeCompletion) {
                    if (status == 3) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Committing compass transaction using JTA synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "]"));
                        }
                        this.session.getSearchEngine().commit(true);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rolling back compass transaction using JTA synchronization afterCompletion on thread [" + Thread.currentThread().getName() + "] with status [" + status + "]"));
                        }
                        this.session.getSearchEngine().rollback();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Exception occured when sync with transaction", (Throwable)e);
            }
            finally {
                this.session.evictAll();
                ((JTASyncTransactionFactory)this.transactionFactory).unbindSessionFromTransaction(this.tx);
                if (!this.compassControlledJtaTransaction) {
                    this.session.close();
                }
            }
        }
    }
}

