/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.ConversionException;
import org.compass.core.metadata.Alias;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.metadata.MetaData;
import org.compass.core.metadata.MetaDataGroup;

public class CommonMetaDataLookup {
    private CompassMetaData metaData;

    public CommonMetaDataLookup(CompassMetaData metaData) {
        this.metaData = metaData;
    }

    public Alias lookupAlias(String value) throws ConfigurationException {
        Alias alias;
        if (value == null) {
            return null;
        }
        if (!value.startsWith("${") || !value.endsWith("}")) {
            return null;
        }
        String val = value.substring(2, value.length() - 1);
        int dotIndex = val.indexOf(".");
        if (dotIndex == -1) {
            throw new ConfigurationException("Mailformed alias lookup value, must have a '.'");
        }
        String groupId = val.substring(0, dotIndex);
        MetaDataGroup group = this.metaData.getGroup(groupId);
        if (group == null) {
            throw new ConfigurationException("Couldn't find group [" + groupId + "] in lookup value [" + val + "]");
        }
        String aliasId = val.substring(dotIndex + 1, val.length());
        if ((dotIndex = aliasId.indexOf(".")) != -1) {
            aliasId = aliasId.substring(0, dotIndex);
        }
        if ((alias = group.getAlias(aliasId)) == null) {
            throw new ConfigurationException("Couldn't find alias for [" + val + "]");
        }
        return alias;
    }

    public String lookupAliasName(String value) throws ConfigurationException {
        Alias alias = this.lookupAlias(value);
        if (alias == null) {
            return value;
        }
        return alias.getName();
    }

    public MetaData lookupMetaData(String value) throws ConfigurationException {
        MetaData metaData;
        if (value == null) {
            return null;
        }
        if (!value.startsWith("${") || !value.endsWith("}")) {
            return null;
        }
        String val = value.substring(2, value.length() - 1);
        int dotIndex = val.indexOf(".");
        if (dotIndex == -1) {
            throw new ConfigurationException("Mailformed meta-data lookup value, must have a '.' with a meta-data-group as the prefix");
        }
        String groupId = val.substring(0, dotIndex);
        MetaDataGroup group = this.metaData.getGroup(groupId);
        if (group == null) {
            throw new ConfigurationException("Couldn't find group [" + groupId + "] in lookup value [" + val + "]");
        }
        String metaDataId = val.substring(dotIndex + 1, val.length());
        if ((dotIndex = metaDataId.indexOf(".")) != -1) {
            metaDataId = metaDataId.substring(0, dotIndex);
        }
        if ((metaData = group.getMetaData(metaDataId)) == null) {
            throw new ConfigurationException("Couldn't find meta-data for [" + val + "]");
        }
        return metaData;
    }

    public String lookupMetaDataName(String value) throws ConfigurationException {
        MetaData metaData = this.lookupMetaData(value);
        if (metaData == null) {
            return value;
        }
        return metaData.getName();
    }

    public String lookupMetaDataFormat(String value) throws ConfigurationException {
        MetaData metaData = this.lookupMetaData(value);
        if (metaData == null) {
            return null;
        }
        return metaData.getFormat();
    }

    public String lookupMetaDataValue(String value) throws ConfigurationException {
        MetaData metaData = this.lookupMetaData(value);
        if (metaData == null) {
            return value;
        }
        int dotIndex = value.lastIndexOf(".");
        if (dotIndex == -1) {
            throw new ConversionException("Must defined a [.] after the meta data for the id of the value with lookup [" + value + "]");
        }
        String valueId = value.substring(dotIndex + 1, value.length() - 1);
        return metaData.getValue(valueId);
    }
}

