/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.handler.ActualDeleteFileEntryHandler;
import org.apache.lucene.store.jdbc.handler.NoOpFileEntryHandler;
import org.apache.lucene.store.jdbc.index.FetchOnOpenJdbcIndexInput;
import org.apache.lucene.store.jdbc.index.RAMJdbcIndexOutput;
import org.apache.lucene.store.jdbc.lock.PhantomReadLock;

public class JdbcDirectorySettings {
    public static String DEFAULT_FILE_ENTRY = "__default__";
    public static final long HOUR = 3600000L;
    private int nameColumnLength = 50;
    private int valueColumnLengthInK = 500000;
    private String nameColumnName = "name_";
    private String valueColumnName = "value_";
    private String sizeColumnName = "size_";
    private String lastModifiedColumnName = "lf_";
    private String deletedColumnName = "deleted_";
    private HashMap fileEntrySettings = new HashMap();
    private long deleteMarkDeletedDelta = 3600000L;
    private int queryTimeout = 10;
    private Class lockClass = PhantomReadLock.class;

    public JdbcDirectorySettings() {
        JdbcFileEntrySettings defaultSettings = new JdbcFileEntrySettings();
        this.registerFileEntrySettings(DEFAULT_FILE_ENTRY, defaultSettings);
        JdbcFileEntrySettings deletableSettings = new JdbcFileEntrySettings();
        deletableSettings.setClassSetting("type", NoOpFileEntryHandler.class);
        this.registerFileEntrySettings("deletable", deletableSettings);
        this.registerFileEntrySettings("deleteable.new", deletableSettings);
        this.registerFileEntrySettings("deletable.new", deletableSettings);
        JdbcFileEntrySettings segmentsSettings = new JdbcFileEntrySettings();
        segmentsSettings.setClassSetting("type", ActualDeleteFileEntryHandler.class);
        segmentsSettings.setClassSetting("indexInput.type", FetchOnOpenJdbcIndexInput.class);
        segmentsSettings.setClassSetting("indexOutput.type", RAMJdbcIndexOutput.class);
        this.registerFileEntrySettings("segments", segmentsSettings);
        this.registerFileEntrySettings("segments.new", segmentsSettings);
        JdbcFileEntrySettings dotDelSettings = new JdbcFileEntrySettings();
        dotDelSettings.setClassSetting("type", ActualDeleteFileEntryHandler.class);
        this.registerFileEntrySettings("del", dotDelSettings);
        JdbcFileEntrySettings tmpSettings = new JdbcFileEntrySettings();
        tmpSettings.setClassSetting("type", ActualDeleteFileEntryHandler.class);
        this.registerFileEntrySettings("tmp", dotDelSettings);
        JdbcFileEntrySettings fnmSettings = new JdbcFileEntrySettings();
        fnmSettings.setClassSetting("indexInput.type", FetchOnOpenJdbcIndexInput.class);
        fnmSettings.setClassSetting("indexOutput.type", RAMJdbcIndexOutput.class);
        this.registerFileEntrySettings("fnm", fnmSettings);
    }

    public int getNameColumnLength() {
        return this.nameColumnLength;
    }

    public void setNameColumnLength(int nameColumnLength) {
        this.nameColumnLength = nameColumnLength;
    }

    public int getValueColumnLengthInK() {
        return this.valueColumnLengthInK;
    }

    public void setValueColumnLengthInK(int valueColumnLengthInK) {
        this.valueColumnLengthInK = valueColumnLengthInK;
    }

    public String getNameColumnName() {
        return this.nameColumnName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public String getSizeColumnName() {
        return this.sizeColumnName;
    }

    public void setSizeColumnName(String sizeColumnName) {
        this.sizeColumnName = sizeColumnName;
    }

    public String getLastModifiedColumnName() {
        return this.lastModifiedColumnName;
    }

    public void setLastModifiedColumnName(String lastModifiedColumnName) {
        this.lastModifiedColumnName = lastModifiedColumnName;
    }

    public String getDeletedColumnName() {
        return this.deletedColumnName;
    }

    public void setDeletedColumnName(String deletedColumnName) {
        this.deletedColumnName = deletedColumnName;
    }

    public void registerFileEntrySettings(String name, JdbcFileEntrySettings fileEntrySettings) {
        this.fileEntrySettings.put(name, fileEntrySettings);
    }

    public Map getFileEntrySettings() {
        return this.fileEntrySettings;
    }

    public JdbcFileEntrySettings getFileEntrySettings(String name) {
        JdbcFileEntrySettings settings = this.getFileEntrySettingsWithoutDefault(name);
        if (settings != null) {
            return settings;
        }
        return this.getDefaultFileEntrySettings();
    }

    public JdbcFileEntrySettings getFileEntrySettingsWithoutDefault(String name) {
        JdbcFileEntrySettings settings = (JdbcFileEntrySettings)this.fileEntrySettings.get(name.substring(name.length() - 3));
        if (settings != null) {
            return settings;
        }
        return (JdbcFileEntrySettings)this.fileEntrySettings.get(name);
    }

    public JdbcFileEntrySettings getDefaultFileEntrySettings() {
        return (JdbcFileEntrySettings)this.fileEntrySettings.get(DEFAULT_FILE_ENTRY);
    }

    public long getDeleteMarkDeletedDelta() {
        return this.deleteMarkDeletedDelta;
    }

    public void setDeleteMarkDeletedDelta(long deleteMarkDeletedDelta) {
        this.deleteMarkDeletedDelta = deleteMarkDeletedDelta;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public Class getLockClass() {
        return this.lockClass;
    }

    public void setLockClass(Class lockClass) {
        this.lockClass = lockClass;
    }
}

