/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.JsonMessage;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String filePath) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            File f = new File(filePath);
            is = new FileInputStream(f);
            props.load(is);
        }
        catch (Exception e) {
            log.error((Object)("Failed to load properties from file: " + filePath), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public static void validateTenantRange(String tenantRange) {
        boolean valid = false;
        if (tenantRange != null) {
            if (tenantRange.equals("*")) {
                valid = true;
            } else {
                String[] array = tenantRange.split("-");
                if (array.length == 2) {
                    if (Util.isNumber(array[0]) && Util.isNumber(array[1])) {
                        valid = true;
                    } else if (Util.isNumber(array[0]) && "*".equals(array[1])) {
                        valid = true;
                    }
                }
            }
        }
        if (!valid) {
            throw new RuntimeException(String.format("Tenant range %s is not valid", tenantRange));
        }
    }

    public static boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static Object jsonToObject(String json, Class type) {
        return new JsonMessage(json, type).getObject();
    }
}

