/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.topology.TopologyMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventMessageQueue;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

class TopologyEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(TopologyEventMessageDelegator.class);
    private MessageProcessorChain processorChain;
    private TopologyEventMessageQueue messageQueue;
    private boolean terminated;

    public TopologyEventMessageDelegator(TopologyEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new TopologyMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Topology event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        TextMessage message = (TextMessage)this.messageQueue.take();
                        String type = message.getStringProperty("event-class-name");
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Topology event message [%s] received from queue: %s", type, this.messageQueue.getClass()));
                        }
                        try {
                            TopologyManager.acquireWriteLock();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Delegating topology event message: %s", type));
                            }
                            this.processorChain.process(type, json, TopologyManager.getTopology());
                        }
                        finally {
                            TopologyManager.releaseWriteLock();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve topology event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block11;
                log.error((Object)"Topology event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

