/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.tenant;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.receiver.tenant.TenantEventMessageQueue;

class TenantEventMessageListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(TenantEventMessageListener.class);
    private TenantEventMessageQueue messageQueue;

    public TenantEventMessageListener(TenantEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage receivedMessage = (TextMessage)message;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Tenant message received: %s", ((TextMessage)message).getText()));
                }
                this.messageQueue.add(receivedMessage);
            }
            catch (JMSException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

