/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.health.stat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.TopicSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageListener;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageQueue;

public class HealthStatEventReceiver
implements Runnable {
    private static final Log log = LogFactory.getLog(HealthStatEventReceiver.class);
    private HealthStatEventMessageDelegator messageDelegator;
    private HealthStatEventMessageListener messageListener;
    private TopicSubscriber topicSubscriber;
    private boolean terminated;

    public HealthStatEventReceiver() {
        HealthStatEventMessageQueue messageQueue = new HealthStatEventMessageQueue();
        this.messageDelegator = new HealthStatEventMessageDelegator(messageQueue);
        this.messageListener = new HealthStatEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block7: {
            try {
                this.topicSubscriber = new TopicSubscriber("summarized-health-stats");
                this.topicSubscriber.setMessageListener(this.messageListener);
                Thread subscriberThread = new Thread(this.topicSubscriber);
                subscriberThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Health stats event message receiver thread started");
                }
                Thread receiverThread = new Thread(this.messageDelegator);
                receiverThread.start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Health stats event message delegator thread started");
                }
                while (!this.terminated) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Topology receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.topicSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }
}

