/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ServiceRemovedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.util.Util;

public class ServiceRemovedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ServiceRemovedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ServiceRemovedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ServiceRemovedEvent event = (ServiceRemovedEvent)Util.jsonToObject(message, ServiceRemovedEvent.class);
            if (TopologyServiceFilter.getInstance().isActive() && TopologyServiceFilter.getInstance().serviceNameExcluded(event.getServiceName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Service is excluded: [service] %s", event.getServiceName()));
                }
                return false;
            }
            Service service = topology.getService(event.getServiceName());
            if (service == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
                }
            } else {
                topology.removeService(service);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Service removed: [service] %s", event.getServiceName()));
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

