/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyMemberFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.util.Util;

public class MemberTerminatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(MemberTerminatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (MemberTerminatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            MemberTerminatedEvent event = (MemberTerminatedEvent)Util.jsonToObject(message, MemberTerminatedEvent.class);
            if (TopologyServiceFilter.getInstance().isActive() && TopologyServiceFilter.getInstance().serviceNameExcluded(event.getServiceName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Service is excluded: [service] %s", event.getServiceName()));
                }
                return false;
            }
            if (TopologyClusterFilter.getInstance().isActive() && TopologyClusterFilter.getInstance().clusterIdExcluded(event.getClusterId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Cluster is excluded: [cluster] %s", event.getClusterId()));
                }
                return false;
            }
            Service service = topology.getService(event.getServiceName());
            if (service == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
                }
                return false;
            }
            Cluster cluster = service.getCluster(event.getClusterId());
            if (cluster == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Cluster does not exist: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
                }
                return false;
            }
            Member member = cluster.getMember(event.getMemberId());
            if (member != null && TopologyMemberFilter.getInstance().isActive() && TopologyMemberFilter.getInstance().lbClusterIdExcluded(member.getLbClusterId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Member is excluded: [lb-cluster-id] %s", member.getLbClusterId()));
                }
                return false;
            }
            if (member == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Member already terminated: [service] %s [cluster] %s [member] %s", event.getServiceName(), event.getClusterId(), event.getMemberId()));
                }
            } else {
                cluster.removeMember(member);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Member terminated: [service] %s [cluster] %s [member] %s", event.getServiceName(), event.getClusterId(), event.getMemberId()));
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

