/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.topology;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.domain.topology.Topology;
import org.apache.stratos.messaging.event.topology.ClusterCreatedEvent;
import org.apache.stratos.messaging.message.filter.topology.TopologyClusterFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.util.Util;

public class ClusterCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ClusterCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    @Override
    public boolean process(String type, String message, Object object) {
        Topology topology = (Topology)object;
        if (ClusterCreatedEvent.class.getName().equals(type)) {
            if (!topology.isInitialized()) {
                return false;
            }
            ClusterCreatedEvent event = (ClusterCreatedEvent)Util.jsonToObject(message, ClusterCreatedEvent.class);
            if (TopologyServiceFilter.getInstance().isActive() && TopologyServiceFilter.getInstance().serviceNameExcluded(event.getServiceName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Service is excluded: [service] %s", event.getServiceName()));
                }
                return false;
            }
            if (TopologyClusterFilter.getInstance().isActive() && TopologyClusterFilter.getInstance().clusterIdExcluded(event.getClusterId())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Cluster is excluded: [cluster] %s", event.getClusterId()));
                }
                return false;
            }
            Cluster cluster = event.getCluster();
            if (cluster == null) {
                String msg = "Cluster object of cluster created event is null.";
                log.error((Object)msg);
                throw new RuntimeException(msg);
            }
            if (cluster.getHostNames().isEmpty()) {
                throw new RuntimeException("Host name/s not found in cluster created event");
            }
            Service service = topology.getService(event.getServiceName());
            if (service == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Service does not exist: [service] %s", event.getServiceName()));
                }
                return false;
            }
            if (service.clusterExists(event.getClusterId())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Cluster already exists in service: [service] %s [cluster] %s", event.getServiceName(), event.getClusterId()));
                }
            } else {
                service.addCluster(cluster);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Cluster created: %s", cluster.toString()));
                }
            }
            this.notifyEventListeners(event);
            return true;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, topology);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }
}

