/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.tenant;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.event.tenant.CompleteTenantEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.receiver.tenant.TenantManager;
import org.apache.stratos.messaging.util.Util;

public class CompleteTenantMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(CompleteTenantMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        if (CompleteTenantEvent.class.getName().equals(type)) {
            if (TenantManager.getInstance().isInitialized()) {
                return false;
            }
            CompleteTenantEvent event = (CompleteTenantEvent)Util.jsonToObject(message, CompleteTenantEvent.class);
            try {
                TenantManager.acquireWriteLock();
                TenantManager.getInstance().addTenants(event.getTenants());
                if (log.isInfoEnabled()) {
                    log.info((Object)"Tenant initialized");
                }
                TenantManager.getInstance().setInitialized(true);
                this.notifyEventListeners(event);
                boolean bl = true;
                return bl;
            }
            finally {
                TenantManager.releaseWriteLock();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, object);
        }
        throw new RuntimeException(String.format("Failed to process tenant message using available message processors: [type] %s [body] %s", type, message));
    }
}

