/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;

public class MessageFilter {
    private static final Log log = LogFactory.getLog(TopologyServiceFilter.class);
    private String filterName;
    private Map<String, Map<String, Boolean>> filterMap;

    public MessageFilter(String filterName) {
        this.filterName = filterName;
        this.filterMap = new HashMap<String, Map<String, Boolean>>();
        this.init();
    }

    private Map<String, String> splitToMap(String filter) {
        HashMap<String, String> keyValuePairMap = new HashMap<String, String>();
        List<String> keyValuePairList = MessageFilter.splitUsingTokenizer(filter, "|");
        for (String keyValuePair : keyValuePairList) {
            List<String> keyValueList = MessageFilter.splitUsingTokenizer(keyValuePair, "=");
            if (keyValueList.size() == 2) {
                keyValuePairMap.put(keyValueList.get(0).trim(), keyValueList.get(1).trim());
                continue;
            }
            throw new RuntimeException(String.format("Invalid key-value pair: %s", keyValuePair));
        }
        return keyValuePairMap;
    }

    public static List<String> splitUsingTokenizer(String string, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        ArrayList<String> list = new ArrayList<String>(string.length());
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public void init() {
        String filter = System.getProperty(this.filterName);
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Initializing filter: %s", this.filterName));
            }
            Map<String, String> keyValuePairMap = this.splitToMap(filter);
            for (String propertyName : keyValuePairMap.keySet()) {
                String[] propertyValueArray;
                String propertyValue = keyValuePairMap.get(propertyName);
                HashMap<String, Boolean> propertyValueMap = new HashMap<String, Boolean>();
                for (String value : propertyValueArray = propertyValue.split(",")) {
                    propertyValueMap.put(value, true);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("Filter property value found: [property] %s [value] %s", propertyName, value));
                }
                this.filterMap.put(propertyName, propertyValueMap);
            }
        }
    }

    public boolean isActive() {
        return this.filterMap.size() > 0;
    }

    public boolean included(String propertyName, String propertyValue) {
        if (this.filterMap.containsKey(propertyName)) {
            Map<String, Boolean> propertyValueMap = this.filterMap.get(propertyName);
            return propertyValueMap.containsKey(propertyValue);
        }
        return false;
    }

    public boolean excluded(String propertyName, String propertyValue) {
        return !this.included(propertyName, propertyValue);
    }

    public Collection<String> getIncludedPropertyValues(String propertyName) {
        if (this.filterMap.containsKey(propertyName)) {
            return this.filterMap.get(propertyName).keySet();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }
}

