/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.stratos.messaging.domain.topology.Service;

public class Topology
implements Serializable {
    private static final long serialVersionUID = -2453583548027402122L;
    private Map<String, Service> serviceMap = new HashMap<String, Service>();
    private boolean initialized;

    public Collection<Service> getServices() {
        return this.serviceMap.values();
    }

    public void addService(Service service) {
        this.serviceMap.put(service.getServiceName(), service);
    }

    public void addServices(Collection<Service> services) {
        for (Service service : services) {
            this.addService(service);
        }
    }

    public void removeService(Service service) {
        this.serviceMap.remove(service.getServiceName());
    }

    public void removeService(String serviceName) {
        this.serviceMap.remove(serviceName);
    }

    public Service getService(String serviceName) {
        return this.serviceMap.get(serviceName);
    }

    public boolean serviceExists(String serviceName) {
        return this.serviceMap.containsKey(serviceName);
    }

    public void clear() {
        this.serviceMap.clear();
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String toString() {
        return "Topology [serviceMap=" + this.serviceMap + ", initialized=" + this.initialized + "]";
    }
}

