/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.util.Util;
import org.apache.stratos.messaging.util.bean.type.map.MapAdapter;

@XmlRootElement
public class Cluster
implements Serializable {
    private static final long serialVersionUID = -361960242360176077L;
    private final String serviceName;
    private final String clusterId;
    private final String autoscalePolicyName;
    private final String deploymentPolicyName;
    private List<String> hostNames;
    private String tenantRange;
    private boolean isLbCluster;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Map<String, Member> memberMap;
    private String loadBalanceAlgorithmName;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Properties properties;

    public Cluster(String serviceName, String clusterId, String deploymentPolicyName, String autoscalePolicyName) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.deploymentPolicyName = deploymentPolicyName;
        this.autoscalePolicyName = autoscalePolicyName;
        this.hostNames = new ArrayList<String>();
        this.memberMap = new HashMap<String, Member>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void addHostName(String hostName) {
        this.hostNames.add(hostName);
    }

    public String getTenantRange() {
        return this.tenantRange;
    }

    public void setTenantRange(String tenantRange) {
        Util.validateTenantRange(tenantRange);
        this.tenantRange = tenantRange;
    }

    public Collection<Member> getMembers() {
        return this.memberMap.values();
    }

    public boolean hasMembers() {
        return this.memberMap.isEmpty();
    }

    public void addMember(Member member) {
        this.memberMap.put(member.getMemberId(), member);
    }

    public void removeMember(Member member) {
        this.memberMap.remove(member.getMemberId());
    }

    public Member getMember(String memberId) {
        return this.memberMap.get(memberId);
    }

    public boolean memberExists(String memberId) {
        return this.memberMap.containsKey(memberId);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getAutoscalePolicyName() {
        return this.autoscalePolicyName;
    }

    public String getDeploymentPolicyName() {
        return this.deploymentPolicyName;
    }

    public String getLoadBalanceAlgorithmName() {
        return this.loadBalanceAlgorithmName;
    }

    public void setLoadBalanceAlgorithmName(String loadBalanceAlgorithmName) {
        this.loadBalanceAlgorithmName = loadBalanceAlgorithmName;
    }

    public boolean isLbCluster() {
        return this.isLbCluster;
    }

    public void setLbCluster(boolean isLbCluster) {
        this.isLbCluster = isLbCluster;
    }

    public String toString() {
        return "Cluster [serviceName=" + this.serviceName + ", clusterId=" + this.clusterId + ", autoscalePolicyName=" + this.autoscalePolicyName + ", deploymentPolicyName=" + this.deploymentPolicyName + ", hostNames=" + this.hostNames + ", tenantRange=" + this.tenantRange + ", isLbCluster=" + this.isLbCluster + ", properties=" + this.properties + "]";
    }

    public boolean tenantIdInRange(int tenantId) {
        if (StringUtils.isBlank((CharSequence)this.getTenantRange())) {
            return false;
        }
        if ("*".equals(this.getTenantRange())) {
            return true;
        }
        String[] array = this.getTenantRange().split("-");
        int tenantStart = Integer.parseInt(array[0]);
        if (tenantStart <= tenantId) {
            String tenantEndStr = array[1];
            if ("*".equals(tenantEndStr)) {
                return true;
            }
            int tenantEnd = Integer.parseInt(tenantEndStr);
            if (tenantId <= tenantEnd) {
                return true;
            }
        }
        return false;
    }

    public Collection<String> findPartitionIds() {
        HashMap<String, Boolean> partitionIds = new HashMap<String, Boolean>();
        for (Member member : this.getMembers()) {
            if (!StringUtils.isNotBlank((CharSequence)member.getPartitionId()) || partitionIds.containsKey(member.getPartitionId())) continue;
            partitionIds.put(member.getPartitionId(), true);
        }
        return partitionIds.keySet();
    }
}

