/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal;

import java.util.concurrent.LinkedBlockingQueue;
import org.wso2.carbon.databridge.commons.Event;

public class EventQueue<E> {
    private LinkedBlockingQueue<Event> eventQueue = new LinkedBlockingQueue();
    private volatile boolean isScheduledForEventDispatching = false;

    public synchronized Event poll() {
        Event event = this.eventQueue.poll();
        if (null == event) {
            this.isScheduledForEventDispatching = false;
        }
        return event;
    }

    public synchronized boolean put(Event event) throws InterruptedException {
        this.eventQueue.put(event);
        if (!this.isScheduledForEventDispatching) {
            this.isScheduledForEventDispatching = true;
            return false;
        }
        return this.isScheduledForEventDispatching;
    }

    public synchronized LinkedBlockingQueue<Event> getAndResetQueue() {
        LinkedBlockingQueue<Event> oldQueue = this.eventQueue;
        this.eventQueue = new LinkedBlockingQueue();
        this.isScheduledForEventDispatching = false;
        return oldQueue;
    }
}

