/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.ConnectionTuneBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;

public class ConnectionTuneBodyImpl
extends AMQMethodBody_0_9
implements ConnectionTuneBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionTuneBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 30;
    private final int _channelMax;
    private final long _frameMax;
    private final int _heartbeat;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionTuneBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._channelMax = this.readUnsignedShort(buffer);
        this._frameMax = this.readUnsignedInteger(buffer);
        this._heartbeat = this.readUnsignedShort(buffer);
    }

    public ConnectionTuneBodyImpl(int channelMax, long frameMax, int heartbeat) {
        this._channelMax = channelMax;
        this._frameMax = frameMax;
        this._heartbeat = heartbeat;
    }

    public int getClazz() {
        return 10;
    }

    public int getMethod() {
        return 30;
    }

    public final int getChannelMax() {
        return this._channelMax;
    }

    public final long getFrameMax() {
        return this._frameMax;
    }

    public final int getHeartbeat() {
        return this._heartbeat;
    }

    protected int getBodySize() {
        int size = 8;
        return size;
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._channelMax);
        this.writeUnsignedInteger(buffer, this._frameMax);
        this.writeUnsignedShort(buffer, this._heartbeat);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchConnectionTune(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionTuneBodyImpl: ");
        buf.append("channelMax=");
        buf.append(this.getChannelMax());
        buf.append(", ");
        buf.append("frameMax=");
        buf.append(this.getFrameMax());
        buf.append(", ");
        buf.append("heartbeat=");
        buf.append(this.getHeartbeat());
        buf.append("]");
        return buf.toString();
    }
}

