/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.permission;

import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;
import org.wso2.carbon.utils.component.xml.Component;
import org.wso2.carbon.utils.component.xml.ComponentConfigFactory;
import org.wso2.carbon.utils.component.xml.config.ManagementPermission;

public class ManagementPermissionsAdder
implements BundleListener {
    private static Log log = LogFactory.getLog(ManagementPermissionsAdder.class);

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            if (event.getType() == 2) {
                this.addUIPermissionFromBundle(bundle);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occured when processing component xml in bundle " + bundle.getSymbolicName()), (Throwable)e);
        }
    }

    public void addUIPermissionFromBundle(Bundle bundle) throws Exception {
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return;
        }
        URL url = bundleContext.getBundle().getEntry("META-INF/component.xml");
        if (url == null) {
            return;
        }
        InputStream xmlStream = url.openStream();
        if (xmlStream == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding permissions in bundle" + bundle.getSymbolicName()));
        }
        Component component = ComponentConfigFactory.build((InputStream)xmlStream);
        ManagementPermission[] uiPermissions = null;
        if (component != null) {
            uiPermissions = (ManagementPermission[])component.getComponentConfig("ManagementPermissions");
        }
        if (uiPermissions != null) {
            UserRegistry registry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry();
            for (ManagementPermission uiPermission : uiPermissions) {
                if (registry.resourceExists(uiPermission.getResourceId())) continue;
                Collection resource = registry.newCollection();
                resource.setProperty("name", uiPermission.getDisplayName());
                registry.put(uiPermission.getResourceId(), (Resource)resource);
            }
        }
    }
}

