/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpResponse;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class AxisHttpResponseImpl
implements AxisHttpResponse,
OutTransportInfo {
    private final HttpResponse response;
    private final AxisHttpConnection conn;
    private final HttpProcessor httpproc;
    private final HttpContext context;
    private AutoCommitOutputStream outstream;
    private String contentType;
    private volatile boolean commited;

    public AxisHttpResponseImpl(AxisHttpConnection conn, HttpResponse response, HttpProcessor httpproc, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException("HTTP connection may not be null");
        }
        if (httpproc == null) {
            throw new IllegalArgumentException("HTTP processor may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        this.response = response;
        this.conn = conn;
        this.httpproc = httpproc;
        this.context = context;
    }

    private void assertNotCommitted() {
        if (this.commited) {
            throw new IllegalStateException("Response already committed");
        }
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void commit() throws IOException, HttpException {
        if (this.commited) {
            return;
        }
        this.commited = true;
        this.context.setAttribute("http.connection", (Object)this.conn);
        this.context.setAttribute("http.response", (Object)this.response);
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setChunked(true);
        entity.setContentType(this.contentType);
        this.response.setEntity((HttpEntity)entity);
        this.httpproc.process(this.response, this.context);
        this.conn.sendResponse(this.response);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outstream == null) {
            this.outstream = new AutoCommitOutputStream();
        }
        return this.outstream;
    }

    @Override
    public void sendError(int sc, String msg) {
        this.assertNotCommitted();
        ProtocolVersion ver = this.response.getProtocolVersion();
        this.response.setStatusLine(ver, sc, msg);
    }

    @Override
    public void sendError(int sc) {
        this.assertNotCommitted();
        this.response.setStatusCode(sc);
    }

    @Override
    public void setStatus(int sc) {
        this.assertNotCommitted();
        this.response.setStatusCode(sc);
    }

    @Override
    public void setContentType(String contentType) {
        this.assertNotCommitted();
        this.contentType = contentType;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public void addHeader(Header header) {
        this.assertNotCommitted();
        this.response.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.assertNotCommitted();
        this.response.addHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.response.getAllHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.response.getFirstHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.response.getHeaders(name);
    }

    public Header getLastHeader(String name) {
        return this.response.getLastHeader(name);
    }

    public HeaderIterator headerIterator() {
        return this.response.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.response.headerIterator(name);
    }

    public void removeHeader(Header header) {
        this.assertNotCommitted();
        this.response.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.assertNotCommitted();
        this.response.removeHeaders(name);
    }

    public void setHeader(Header header) {
        this.assertNotCommitted();
        this.response.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.assertNotCommitted();
        this.response.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.assertNotCommitted();
        this.response.setHeaders(headers);
    }

    public HttpParams getParams() {
        return this.response.getParams();
    }

    public void setParams(HttpParams params) {
        this.response.setParams(params);
    }

    class AutoCommitOutputStream
    extends OutputStream {
        private OutputStream out;

        private void ensureCommitted() throws IOException {
            try {
                AxisHttpResponseImpl.this.commit();
            }
            catch (HttpException ex) {
                throw (IOException)new IOException().initCause(ex);
            }
            if (this.out == null) {
                this.out = AxisHttpResponseImpl.this.conn.getOutputStream();
            }
        }

        @Override
        public void close() throws IOException {
            this.ensureCommitted();
            this.out.close();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.ensureCommitted();
            this.out.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.ensureCommitted();
            this.out.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.ensureCommitted();
            this.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.ensureCommitted();
            this.out.flush();
        }
    }
}

