/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import java.io.Reader;
import java.io.StringReader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvocationContext;
import org.apache.axis2.jaxws.handler.HandlerInvoker;
import org.apache.axis2.jaxws.handler.HandlerInvokerUtils;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.handler.HandlerUtils;
import org.apache.axis2.jaxws.handler.factory.HandlerInvokerFactory;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManager;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationHelper;
import org.apache.axis2.jaxws.server.InvocationListener;
import org.apache.axis2.jaxws.server.InvocationListenerBean;
import org.apache.axis2.jaxws.server.InvocationListenerFactory;
import org.apache.axis2.jaxws.server.ServiceInstanceFactory;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.axis2.jaxws.server.dispatcher.ProviderDispatcher;
import org.apache.axis2.jaxws.server.dispatcher.factory.EndpointDispatcherFactory;
import org.apache.axis2.jaxws.server.endpoint.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointController {
    private static final Log log = LogFactory.getLog(EndpointController.class);

    public EndpointInvocationContext invoke(EndpointInvocationContext eic) throws AxisFault, WebServiceException {
        block13: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invocation pattern: synchronous");
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            boolean good = true;
            try {
                good = this.handleRequest(eic);
                if (!good) {
                    EndpointInvocationContext endpointInvocationContext = eic;
                    return endpointInvocationContext;
                }
                org.apache.axis2.jaxws.core.MessageContext response = null;
                EndpointDispatcher dispatcher = eic.getDispatcher();
                if (request != null && dispatcher != null) {
                    response = dispatcher.invoke(request);
                    eic.setResponseMessageContext(response);
                    break block13;
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invokeErr"));
            }
            catch (AxisFault af) {
                throw af;
            }
            catch (Exception e) {
                Throwable toBeThrown = InvocationHelper.determineMappedException((Throwable)e, eic);
                if (toBeThrown == null) {
                    toBeThrown = e;
                }
                throw ExceptionFactory.makeWebServiceException(toBeThrown);
            }
            finally {
                if (good) {
                    request.getMessage().setPostPivot();
                    this.handleResponse(eic);
                } else {
                    this.destroyHandlers(eic, request);
                }
                ContextUtils.releaseWebServiceContextResources(request);
            }
        }
        return eic;
    }

    public void invokeAsync(EndpointInvocationContext eic) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invocation pattern: asynchronous");
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            try {
                boolean good = this.handleRequest(eic);
                if (!good) {
                    return;
                }
                EndpointDispatcher dispatcher = eic.getDispatcher();
                if (request != null && dispatcher != null) {
                    dispatcher.invokeAsync(request, eic.getCallback());
                    break block10;
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invokeErr"));
            }
            catch (Exception e) {
                Throwable toBeThrown = InvocationHelper.determineMappedException((Throwable)e, eic);
                if (toBeThrown == null) {
                    toBeThrown = e;
                }
                throw ExceptionFactory.makeWebServiceException(toBeThrown);
            }
            finally {
                request.getMessage().setPostPivot();
            }
        }
    }

    public void invokeOneWay(EndpointInvocationContext eic) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invocation pattern: one-way");
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            try {
                boolean good = this.handleRequest(eic);
                if (!good) {
                    return;
                }
                EndpointDispatcher dispatcher = eic.getDispatcher();
                if (request != null && dispatcher != null) {
                    dispatcher.invokeOneWay(request);
                    break block10;
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("invokeErr"));
            }
            catch (Exception e) {
                Throwable toBeThrown = InvocationHelper.determineMappedException((Throwable)e, eic);
                if (toBeThrown == null) {
                    toBeThrown = e;
                }
                throw ExceptionFactory.makeWebServiceException(toBeThrown);
            }
            finally {
                request.getMessage().setPostPivot();
            }
        }
    }

    protected boolean handleRequest(EndpointInvocationContext eic) throws AxisFault, WebServiceException {
        org.apache.axis2.jaxws.core.MessageContext responseMsgContext = null;
        try {
            this.requestReceived(eic);
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            Class serviceEndpoint = this.getServiceImplementation(request);
            EndpointDescription endpointDesc = this.getEndpointDescription(request);
            request.setEndpointDescription(endpointDesc);
            List<String> handlerRoles = null;
            if (eic.getHandlers() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No handlers found on the InvocationContext, initializing handler list.");
                }
                HandlerResolverImpl hri = new HandlerResolverImpl(endpointDesc.getServiceDescription());
                PortInfo portInfo = endpointDesc.getPortInfo();
                eic.setHandlers(hri.getHandlerChain(portInfo));
                handlerRoles = hri.getRoles(portInfo);
            }
            ServiceInstanceFactory instanceFactory = (ServiceInstanceFactory)FactoryRegistry.getFactory(ServiceInstanceFactory.class);
            Object serviceInstance = instanceFactory.createServiceInstance(request, serviceEndpoint);
            this.saveRequestMessage(request);
            boolean success = true;
            if (request.getAxisMessageContext() != null && request.getAxisMessageContext().getEnvelope().getHeader() != null || eic.getHandlers() != null && !eic.getHandlers().isEmpty()) {
                success = this.inboundHeaderAndHandlerProcessing(request, eic, handlerRoles);
            }
            if (success) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JAX-WS inbound handler chain invocation complete.");
                }
                EndpointDispatcher dispatcher = this.getEndpointDispatcher(request, serviceEndpoint, serviceInstance);
                Boolean ignoreSOAPVersion = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking for ProviderDispatcher instance");
                }
                if (dispatcher instanceof ProviderDispatcher) {
                    String bindingType;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"ProviderDispatcher instance Found");
                    }
                    if ((bindingType = endpointDesc.getBindingType()).equals("SOAP_HTTP_BINDING")) {
                        ignoreSOAPVersion = true;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ignoreSOAPVersion Value =" + ignoreSOAPVersion));
                    }
                }
                if (!ignoreSOAPVersion.booleanValue() && !Utils.bindingTypesMatch(request, endpointDesc)) {
                    Protocol protocol = request.getMessage().getProtocol();
                    org.apache.axis2.jaxws.core.MessageContext faultContext = Utils.createVersionMismatchMessage(request, protocol);
                    eic.setResponseMessageContext(faultContext);
                    return false;
                }
                eic.setEndpointDispatcher(dispatcher);
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"JAX-WS inbound handler chain invocation completed with errors.");
            }
            responseMsgContext = MessageContextUtils.createResponseMessageContext(request);
            responseMsgContext.setMessage(request.getMessage());
            eic.setResponseMessageContext(responseMsgContext);
            this.responseReady(eic);
            return false;
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    private boolean inboundHeaderAndHandlerProcessing(org.apache.axis2.jaxws.core.MessageContext request, EndpointInvocationContext eic, List<String> handlerRoles) throws AxisFault {
        List<QName> understood = HandlerUtils.registerSOAPHandlerHeaders(request.getAxisMessageContext(), eic.getHandlers());
        HandlerUtils.checkMustUnderstand(request.getAxisMessageContext(), understood, handlerRoles);
        HandlerInvocationContext hiContext = EndpointController.buildHandlerInvocationContext(request, eic.getHandlers(), HandlerChainProcessor.MEP.REQUEST, EndpointController.isOneWay(request.getAxisMessageContext()));
        HandlerInvokerFactory hiFactory = (HandlerInvokerFactory)FactoryRegistry.getFactory(HandlerInvokerFactory.class);
        HandlerInvoker handlerInvoker = hiFactory.createHandlerInvoker(request);
        boolean success = handlerInvoker.invokeInboundHandlers(hiContext);
        return success;
    }

    protected boolean handleResponse(EndpointInvocationContext eic) {
        org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
        org.apache.axis2.jaxws.core.MessageContext response = eic.getResponseMessageContext();
        try {
            if (response != null) {
                EndpointDescription endpointDesc = request.getEndpointDescription();
                String bindingType = endpointDesc.getBindingType();
                if (bindingType.equals("SOAP_HTTP_BINDING")) {
                    org.apache.axis2.jaxws.core.MessageContext faultContext;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Check for protocol mismatch");
                    }
                    if ((faultContext = this.isProtocolMismatch(request, response)) != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"There is a protocol mismatch, generating fault message");
                        }
                        eic.setResponseMessageContext(faultContext);
                        boolean bl = false;
                        return bl;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"There is no protocol mismatch");
                    }
                }
                if (!EndpointController.isOneWay(request.getAxisMessageContext())) {
                    response.setMEPContext(request.getMEPContext());
                    HandlerInvocationContext hiContext = EndpointController.buildHandlerInvocationContext(request, eic.getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
                    HandlerInvokerFactory hiFactory = (HandlerInvokerFactory)FactoryRegistry.getFactory(HandlerInvokerFactory.class);
                    HandlerInvoker handlerInvoker = hiFactory.createHandlerInvoker(response);
                    handlerInvoker.invokeOutboundHandlers(hiContext);
                }
            } else if (MessageContextUtils.getJaxwsProviderInterpretNullOneway(request)) {
                HandlerInvokerUtils.invokeInboundHandlersForClosure(request.getMEPContext(), eic.getHandlers(), HandlerChainProcessor.MEP.RESPONSE);
            }
        }
        catch (Exception e) {
            Throwable toBeThrown = InvocationHelper.determineMappedException((Throwable)e, eic);
            if (toBeThrown == null) {
                toBeThrown = e;
            }
            throw ExceptionFactory.makeWebServiceException(toBeThrown);
        }
        finally {
            this.destroyHandlers(eic, request);
            this.responseReady(eic);
            this.restoreRequestMessage(request);
        }
        eic.setResponseMessageContext(response);
        return true;
    }

    private void destroyHandlers(EndpointInvocationContext eic, org.apache.axis2.jaxws.core.MessageContext request) {
        HandlerLifecycleManager hlm = this.createHandlerlifecycleManager();
        List<Handler> list = eic.getHandlers();
        if (list != null) {
            Iterator<Handler> it = list.iterator();
            while (it.hasNext()) {
                try {
                    Handler handler = it.next();
                    hlm.destroyHandlerInstance(request, handler);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
            }
        }
    }

    private Class getServiceImplementation(org.apache.axis2.jaxws.core.MessageContext mc) {
        String implClassName = this.getServiceImplClassName(mc);
        Class implClass = this.loadServiceImplClass(implClassName, mc.getClassLoader());
        return implClass;
    }

    protected EndpointDispatcher getEndpointDispatcher(Class serviceImplClass, Object serviceInstance) throws Exception {
        return this.getEndpointDispatcher(null, serviceImplClass, serviceInstance);
    }

    protected EndpointDispatcher getEndpointDispatcher(org.apache.axis2.jaxws.core.MessageContext mc, Class serviceImplClass, Object serviceInstance) throws Exception {
        EndpointDispatcherFactory factory = (EndpointDispatcherFactory)FactoryRegistry.getFactory(EndpointDispatcherFactory.class);
        return factory.createEndpointDispatcher(mc, serviceImplClass, serviceInstance);
    }

    private String getServiceImplClassName(org.apache.axis2.jaxws.core.MessageContext mc) {
        MessageContext axisMsgContext = mc.getAxisMessageContext();
        AxisService as = axisMsgContext.getAxisService();
        Parameter param = as.getParameter("ServiceClass");
        if (param == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("EndpointControllerErr2"));
        }
        String className = ((String)param.getValue()).trim();
        return className;
    }

    private Class loadServiceImplClass(String className, ClassLoader cl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to load service impl class: " + className));
        }
        try {
            Class _class = EndpointController.forName(className, true, cl);
            return _class;
        }
        catch (Throwable cnf) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("EndpointControllerErr4", className), cnf);
        }
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PrivilegedActionException thrown from AccessController: " + e));
                log.debug((Object)("Real Cause is " + e.getException().getCause()));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private EndpointDescription getEndpointDescription(org.apache.axis2.jaxws.core.MessageContext mc) {
        AxisService axisSvc = mc.getAxisMessageContext().getAxisService();
        Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        if (param == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("endpointDescErr1"));
        }
        EndpointDescription ed = (EndpointDescription)param.getValue();
        return ed;
    }

    private void saveRequestMessage(org.apache.axis2.jaxws.core.MessageContext requestMsgContext) {
        Boolean value = (Boolean)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG");
        if (value != null && value.booleanValue()) {
            Message m = requestMsgContext.getMessage();
            String savedMsg = m.getAsOMElement().toString();
            requestMsgContext.getAxisMessageContext().setProperty("org.apache.axis2.jaxws.spi.SAVED_REQUEST_MSG_TEXT", savedMsg);
        }
    }

    private void restoreRequestMessage(org.apache.axis2.jaxws.core.MessageContext requestMsgContext) {
        String savedMsg;
        Boolean value = (Boolean)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVE_REQUEST_MSG");
        if (value != null && value.booleanValue() && (savedMsg = (String)requestMsgContext.getAxisMessageContext().getProperty("org.apache.axis2.jaxws.spi.SAVED_REQUEST_MSG_TEXT")) != null && savedMsg.length() > 0) {
            try {
                StringReader sr = new StringReader(savedMsg);
                XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((Reader)sr);
                MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                Protocol protocol = requestMsgContext.getAxisMessageContext().isDoingREST() ? Protocol.rest : null;
                Message msg = mf.createFrom(xmlreader, protocol);
                requestMsgContext.setMessage(msg);
            }
            catch (Throwable e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
    }

    public static boolean isOneWay(MessageContext mc) {
        AxisOperation op;
        String mep;
        return mc != null && ((mep = (op = mc.getAxisOperation()).getMessageExchangePattern()).equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only"));
    }

    static HandlerInvocationContext buildHandlerInvocationContext(org.apache.axis2.jaxws.core.MessageContext request, List<Handler> handlers, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        HandlerInvocationContext hiContext = new HandlerInvocationContext();
        hiContext.setMessageContext(request);
        hiContext.setMEP(mep);
        hiContext.setHandlers(handlers);
        hiContext.setOneWay(isOneWay);
        return hiContext;
    }

    protected void requestReceived(EndpointInvocationContext eic) {
        Collection<InvocationListenerFactory> factoryList = eic.getInvocationListenerFactories();
        if (factoryList != null) {
            InvocationListenerBean bean = new InvocationListenerBean(eic, InvocationListenerBean.State.REQUEST);
            for (InvocationListenerFactory factory : factoryList) {
                InvocationListener listener = factory.createInvocationListener(eic.getRequestMessageContext());
                if (listener == null) continue;
                try {
                    listener.notify(bean);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
                finally {
                    eic.addInvocationListener(listener);
                }
            }
            org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
            request.setProperty("org.apache.axis2.jaxws.spi.INVOCATION_LISTENER_LIST", eic.getInvocationListeners());
        }
    }

    protected void responseReady(EndpointInvocationContext eic) {
        List<InvocationListener> listenerList = eic.getInvocationListeners();
        if (listenerList != null) {
            InvocationListenerBean bean = new InvocationListenerBean(eic, InvocationListenerBean.State.RESPONSE);
            for (InvocationListener listener : listenerList) {
                try {
                    listener.notify(bean);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
            }
        }
    }

    private HandlerLifecycleManager createHandlerlifecycleManager() {
        HandlerLifecycleManagerFactory elmf = (HandlerLifecycleManagerFactory)FactoryRegistry.getFactory(HandlerLifecycleManagerFactory.class);
        return elmf.createHandlerLifecycleManager();
    }

    private org.apache.axis2.jaxws.core.MessageContext isProtocolMismatch(org.apache.axis2.jaxws.core.MessageContext request, org.apache.axis2.jaxws.core.MessageContext response) {
        Protocol requestProtocol = request.getMessage().getProtocol();
        Protocol responseProtocol = response.getMessage().getProtocol();
        boolean protocolMismatch = false;
        String msg = null;
        if (requestProtocol.equals((Object)Protocol.soap11)) {
            if (!responseProtocol.equals((Object)Protocol.soap11)) {
                protocolMismatch = true;
                msg = "Request SOAP message protocol is version 1.1, but Response SOAP message is configured for SOAP 1.2.  This is not supported.";
            }
        } else if (requestProtocol.equals((Object)Protocol.soap12) && !responseProtocol.equals((Object)Protocol.soap12)) {
            protocolMismatch = true;
            msg = "Request SOAP message protocol is version 1.2, but Response SOAP message is configured for SOAP 1.1.  This is not supported.";
        }
        org.apache.axis2.jaxws.core.MessageContext msgContext = null;
        if (protocolMismatch) {
            msgContext = Utils.createFaultMessage(response, msg);
        }
        return msgContext;
    }
}

