/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.streams.functions;

import java.util.Collections;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.StormContext;
import org.apache.storm.sql.runtime.calcite.DebuggableExecutableExpression;
import org.apache.storm.sql.runtime.calcite.ExecutableExpression;
import org.apache.storm.streams.operations.FlatMapFunction;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationCalc
implements FlatMapFunction<Values, Values> {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationCalc.class);
    private final ExecutableExpression filterInstance;
    private final ExecutableExpression projectionInstance;
    private final Object[] outputValues;
    private final DataContext dataContext;

    public EvaluationCalc(ExecutableExpression filterInstance, ExecutableExpression projectionInstance, int outputCount, DataContext dataContext) {
        this.filterInstance = filterInstance;
        this.projectionInstance = projectionInstance;
        this.outputValues = new Object[outputCount];
        this.dataContext = dataContext;
        if (projectionInstance != null && projectionInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code for projection: \n{}", (Object)((DebuggableExecutableExpression)projectionInstance).getDelegateCode());
        }
        if (filterInstance != null && filterInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code for filter: \n{}", (Object)((DebuggableExecutableExpression)filterInstance).getDelegateCode());
        }
    }

    public Iterable<Values> apply(Values input) {
        StormContext calciteContext = new StormContext(this.dataContext);
        calciteContext.values = input.toArray();
        if (this.filterInstance != null) {
            this.filterInstance.execute(calciteContext, this.outputValues);
            if (this.outputValues[0] == null || !((Boolean)this.outputValues[0]).booleanValue()) {
                return Collections.emptyList();
            }
        }
        if (this.projectionInstance != null) {
            this.projectionInstance.execute(calciteContext, this.outputValues);
            return Collections.singletonList(new Values(this.outputValues));
        }
        return Collections.singletonList(new Values(input.toArray()));
    }
}

