/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.hdfs;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.storm.hdfs.bolt.HdfsBolt;
import org.apache.storm.hdfs.bolt.format.FileNameFormat;
import org.apache.storm.hdfs.bolt.format.RecordFormat;
import org.apache.storm.hdfs.bolt.format.SimpleFileNameFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.FileSizeRotationPolicy;
import org.apache.storm.hdfs.bolt.rotation.TimedRotationPolicy;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlStreamsDataSource;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class HdfsDataSourcesProvider
implements DataSourcesProvider {
    private static final String PROPERTY_HDFS_FILE_PATH = "hdfs.file.path";
    private static final String PROPERTY_HDFS_FILE_NAME = "hdfs.file.name";
    private static final String DEFAULT_VALUE_HDFS_FILE_PATH = "/storm";
    private static final String DEFAULT_VALUE_HDF_FILE_NAME = "$TIME.$NUM.txt";
    private static final String PROPERTY_HDFS_ROTATION_SIZE_KB = "hdfs.rotation.size.kb";
    private static final String PROPERTY_HDFS_ROTATION_TIME_SECONDS = "hdfs.rotation.time.seconds";
    private static final String SCHEME_NAME = "hdfs";

    public String scheme() {
        return SCHEME_NAME;
    }

    public ISqlStreamsDataSource constructStreams(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        List fieldNames = FieldInfoUtils.getFieldNames(fields);
        IOutputSerializer serializer = SerdeUtils.getSerializer((String)outputFormatClass, (Properties)properties, (List)fieldNames);
        return new HdfsStreamsDataSource(uri.toString(), properties, serializer);
    }

    private static class HdfsStreamsDataSource
    implements ISqlStreamsDataSource {
        private final String url;
        private final Properties props;
        private final IOutputSerializer serializer;

        private HdfsStreamsDataSource(String url, Properties props, IOutputSerializer serializer) {
            this.url = url;
            this.props = props;
            this.serializer = serializer;
        }

        public IRichSpout getProducer() {
            throw new UnsupportedOperationException(this.getClass().getName() + " doesn't provide Producer");
        }

        public IRichBolt getConsumer() {
            SimpleFileNameFormat fileNameFormat = new SimpleFileNameFormat().withPath(this.props.getProperty(HdfsDataSourcesProvider.PROPERTY_HDFS_FILE_PATH, HdfsDataSourcesProvider.DEFAULT_VALUE_HDFS_FILE_PATH)).withName(this.props.getProperty(HdfsDataSourcesProvider.PROPERTY_HDFS_FILE_NAME, HdfsDataSourcesProvider.DEFAULT_VALUE_HDF_FILE_NAME));
            StreamsRecordFormat recordFormat = new StreamsRecordFormat(this.serializer);
            String size = this.props.getProperty(HdfsDataSourcesProvider.PROPERTY_HDFS_ROTATION_SIZE_KB);
            String interval = this.props.getProperty(HdfsDataSourcesProvider.PROPERTY_HDFS_ROTATION_TIME_SECONDS);
            Preconditions.checkArgument((size != null || interval != null ? 1 : 0) != 0, (Object)"Hdfs data source must contain file rotation config");
            Object rotationPolicy = size != null ? new FileSizeRotationPolicy(Float.parseFloat(size), FileSizeRotationPolicy.Units.KB) : new TimedRotationPolicy(Float.parseFloat(interval), TimedRotationPolicy.TimeUnit.SECONDS);
            return new HdfsBolt().withFileNameFormat((FileNameFormat)fileNameFormat).withRecordFormat((RecordFormat)recordFormat).withRotationPolicy((FileRotationPolicy)rotationPolicy).withFsUrl(this.url);
        }
    }

    private static class StreamsRecordFormat
    implements RecordFormat {
        private final IOutputSerializer serializer;

        private StreamsRecordFormat(IOutputSerializer serializer) {
            this.serializer = serializer;
        }

        public byte[] format(Tuple tuple) {
            Values values = (Values)tuple.getValue(1);
            return this.serializer.write((List)values, null).array();
        }
    }
}

